/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.pipeline.v1.Provenance;
import io.fabric8.tekton.pipeline.v1.ProvenanceBuilder;
import io.fabric8.tekton.pipeline.v1.ProvenanceFluentImpl;
import io.fabric8.tekton.pipeline.v1.SidecarState;
import io.fabric8.tekton.pipeline.v1.SidecarStateBuilder;
import io.fabric8.tekton.pipeline.v1.SidecarStateFluentImpl;
import io.fabric8.tekton.pipeline.v1.StepState;
import io.fabric8.tekton.pipeline.v1.StepStateBuilder;
import io.fabric8.tekton.pipeline.v1.StepStateFluentImpl;
import io.fabric8.tekton.pipeline.v1.TaskRunResult;
import io.fabric8.tekton.pipeline.v1.TaskRunResultBuilder;
import io.fabric8.tekton.pipeline.v1.TaskRunResultFluentImpl;
import io.fabric8.tekton.pipeline.v1.TaskRunStatus;
import io.fabric8.tekton.pipeline.v1.TaskRunStatusBuilder;
import io.fabric8.tekton.pipeline.v1.TaskRunStatusFluent;
import io.fabric8.tekton.pipeline.v1.TaskSpec;
import io.fabric8.tekton.pipeline.v1.TaskSpecBuilder;
import io.fabric8.tekton.pipeline.v1.TaskSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskRunStatusFluentImpl<A extends TaskRunStatusFluent<A>>
extends BaseFluent<A>
implements TaskRunStatusFluent<A> {
    private Map<String, String> annotations;
    private String completionTime;
    private List<Condition> conditions = new ArrayList<Condition>();
    private Long observedGeneration;
    private String podName;
    private ProvenanceBuilder provenance;
    private ArrayList<TaskRunResultBuilder> results = new ArrayList();
    private ArrayList<TaskRunStatusBuilder> retriesStatus = new ArrayList();
    private ArrayList<SidecarStateBuilder> sidecars = new ArrayList();
    private Map<String, String> spanContext;
    private String startTime;
    private ArrayList<StepStateBuilder> steps = new ArrayList();
    private TaskSpecBuilder taskSpec;

    public TaskRunStatusFluentImpl() {
    }

    public TaskRunStatusFluentImpl(TaskRunStatus instance) {
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withCompletionTime(instance.getCompletionTime());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPodName(instance.getPodName());
            this.withProvenance(instance.getProvenance());
            this.withResults(instance.getResults());
            this.withRetriesStatus(instance.getRetriesStatus());
            this.withSidecars(instance.getSidecars());
            this.withSpanContext(instance.getSpanContext());
            this.withStartTime(instance.getStartTime());
            this.withSteps(instance.getSteps());
            this.withTaskSpec(instance.getTaskSpec());
        }
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getPodName() {
        return this.podName;
    }

    @Override
    public A withPodName(String podName) {
        this.podName = podName;
        return (A)this;
    }

    @Override
    public Boolean hasPodName() {
        return this.podName != null;
    }

    @Override
    @Deprecated
    public Provenance getProvenance() {
        return this.provenance != null ? this.provenance.build() : null;
    }

    @Override
    public Provenance buildProvenance() {
        return this.provenance != null ? this.provenance.build() : null;
    }

    @Override
    public A withProvenance(Provenance provenance) {
        this._visitables.get((Object)"provenance").remove(this.provenance);
        if (provenance != null) {
            this.provenance = new ProvenanceBuilder(provenance);
            this._visitables.get((Object)"provenance").add(this.provenance);
        } else {
            this.provenance = null;
            this._visitables.get((Object)"provenance").remove(this.provenance);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProvenance() {
        return this.provenance != null;
    }

    @Override
    public TaskRunStatusFluent.ProvenanceNested<A> withNewProvenance() {
        return new ProvenanceNestedImpl();
    }

    @Override
    public TaskRunStatusFluent.ProvenanceNested<A> withNewProvenanceLike(Provenance item) {
        return new ProvenanceNestedImpl(item);
    }

    @Override
    public TaskRunStatusFluent.ProvenanceNested<A> editProvenance() {
        return this.withNewProvenanceLike(this.getProvenance());
    }

    @Override
    public TaskRunStatusFluent.ProvenanceNested<A> editOrNewProvenance() {
        return this.withNewProvenanceLike(this.getProvenance() != null ? this.getProvenance() : new ProvenanceBuilder().build());
    }

    @Override
    public TaskRunStatusFluent.ProvenanceNested<A> editOrNewProvenanceLike(Provenance item) {
        return this.withNewProvenanceLike(this.getProvenance() != null ? this.getProvenance() : item);
    }

    @Override
    public A addToResults(int index, TaskRunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(index, builder);
            this.results.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToResults(int index, TaskRunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").set(index, builder);
            this.results.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResults(TaskRunResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResults(Collection<TaskRunResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResults(TaskRunResult ... items) {
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResults(Collection<TaskRunResult> items) {
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResults(Predicate<TaskRunResultBuilder> predicate) {
        if (this.results == null) {
            return (A)this;
        }
        Iterator<TaskRunResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            TaskRunResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TaskRunResult> getResults() {
        return this.results != null ? TaskRunStatusFluentImpl.build(this.results) : null;
    }

    @Override
    public List<TaskRunResult> buildResults() {
        return this.results != null ? TaskRunStatusFluentImpl.build(this.results) : null;
    }

    @Override
    public TaskRunResult buildResult(int index) {
        return this.results.get(index).build();
    }

    @Override
    public TaskRunResult buildFirstResult() {
        return this.results.get(0).build();
    }

    @Override
    public TaskRunResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    @Override
    public TaskRunResult buildMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        for (TaskRunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        for (TaskRunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResults(List<TaskRunResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (TaskRunResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)this;
    }

    @Override
    public A withResults(TaskRunResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (TaskRunResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> addNewResultLike(TaskRunResult item) {
        return new ResultsNestedImpl(-1, item);
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> setNewResultLike(int index, TaskRunResult item) {
        return new ResultsNestedImpl(index, item);
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public TaskRunStatusFluent.ResultsNested<A> editMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public A addToRetriesStatus(int index, TaskRunStatus item) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
        if (index < 0 || index >= this.retriesStatus.size()) {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        } else {
            this._visitables.get((Object)"retriesStatus").add(index, builder);
            this.retriesStatus.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToRetriesStatus(int index, TaskRunStatus item) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
        if (index < 0 || index >= this.retriesStatus.size()) {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        } else {
            this._visitables.get((Object)"retriesStatus").set(index, builder);
            this.retriesStatus.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRetriesStatus(TaskRunStatus ... items) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRetriesStatus(Collection<TaskRunStatus> items) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRetriesStatus(TaskRunStatus ... items) {
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").remove(builder);
            if (this.retriesStatus == null) continue;
            this.retriesStatus.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items) {
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").remove(builder);
            if (this.retriesStatus == null) continue;
            this.retriesStatus.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        if (this.retriesStatus == null) {
            return (A)this;
        }
        Iterator<TaskRunStatusBuilder> each = this.retriesStatus.iterator();
        List visitables = this._visitables.get((Object)"retriesStatus");
        while (each.hasNext()) {
            TaskRunStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TaskRunStatus> getRetriesStatus() {
        return this.retriesStatus != null ? TaskRunStatusFluentImpl.build(this.retriesStatus) : null;
    }

    @Override
    public List<TaskRunStatus> buildRetriesStatus() {
        return this.retriesStatus != null ? TaskRunStatusFluentImpl.build(this.retriesStatus) : null;
    }

    @Override
    public TaskRunStatus buildRetriesStatus(int index) {
        return this.retriesStatus.get(index).build();
    }

    @Override
    public TaskRunStatus buildFirstRetriesStatus() {
        return this.retriesStatus.get(0).build();
    }

    @Override
    public TaskRunStatus buildLastRetriesStatus() {
        return this.retriesStatus.get(this.retriesStatus.size() - 1).build();
    }

    @Override
    public TaskRunStatus buildMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        for (TaskRunStatusBuilder item : this.retriesStatus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        for (TaskRunStatusBuilder item : this.retriesStatus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRetriesStatus(List<TaskRunStatus> retriesStatus) {
        if (this.retriesStatus != null) {
            this._visitables.get((Object)"retriesStatus").clear();
        }
        if (retriesStatus != null) {
            this.retriesStatus = new ArrayList();
            for (TaskRunStatus item : retriesStatus) {
                this.addToRetriesStatus(item);
            }
        } else {
            this.retriesStatus = null;
        }
        return (A)this;
    }

    @Override
    public A withRetriesStatus(TaskRunStatus ... retriesStatus) {
        if (this.retriesStatus != null) {
            this.retriesStatus.clear();
            this._visitables.remove((Object)"retriesStatus");
        }
        if (retriesStatus != null) {
            for (TaskRunStatus item : retriesStatus) {
                this.addToRetriesStatus(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRetriesStatus() {
        return this.retriesStatus != null && !this.retriesStatus.isEmpty();
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatus() {
        return new RetriesStatusNestedImpl();
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item) {
        return new RetriesStatusNestedImpl(-1, item);
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> setNewRetriesStatusLike(int index, TaskRunStatus item) {
        return new RetriesStatusNestedImpl(index, item);
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> editRetriesStatus(int index) {
        if (this.retriesStatus.size() <= index) {
            throw new RuntimeException("Can't edit retriesStatus. Index exceeds size.");
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> editFirstRetriesStatus() {
        if (this.retriesStatus.size() == 0) {
            throw new RuntimeException("Can't edit first retriesStatus. The list is empty.");
        }
        return this.setNewRetriesStatusLike(0, this.buildRetriesStatus(0));
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> editLastRetriesStatus() {
        int index = this.retriesStatus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last retriesStatus. The list is empty.");
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    @Override
    public TaskRunStatusFluent.RetriesStatusNested<A> editMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.retriesStatus.size(); ++i) {
            if (!predicate.test(this.retriesStatus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching retriesStatus. No match found.");
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    @Override
    public A addToSidecars(int index, SidecarState item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        SidecarStateBuilder builder = new SidecarStateBuilder(item);
        if (index < 0 || index >= this.sidecars.size()) {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        } else {
            this._visitables.get((Object)"sidecars").add(index, builder);
            this.sidecars.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSidecars(int index, SidecarState item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        SidecarStateBuilder builder = new SidecarStateBuilder(item);
        if (index < 0 || index >= this.sidecars.size()) {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        } else {
            this._visitables.get((Object)"sidecars").set(index, builder);
            this.sidecars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSidecars(SidecarState ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSidecars(Collection<SidecarState> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSidecars(SidecarState ... items) {
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").remove(builder);
            if (this.sidecars == null) continue;
            this.sidecars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSidecars(Collection<SidecarState> items) {
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").remove(builder);
            if (this.sidecars == null) continue;
            this.sidecars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSidecars(Predicate<SidecarStateBuilder> predicate) {
        if (this.sidecars == null) {
            return (A)this;
        }
        Iterator<SidecarStateBuilder> each = this.sidecars.iterator();
        List visitables = this._visitables.get((Object)"sidecars");
        while (each.hasNext()) {
            SidecarStateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SidecarState> getSidecars() {
        return this.sidecars != null ? TaskRunStatusFluentImpl.build(this.sidecars) : null;
    }

    @Override
    public List<SidecarState> buildSidecars() {
        return this.sidecars != null ? TaskRunStatusFluentImpl.build(this.sidecars) : null;
    }

    @Override
    public SidecarState buildSidecar(int index) {
        return this.sidecars.get(index).build();
    }

    @Override
    public SidecarState buildFirstSidecar() {
        return this.sidecars.get(0).build();
    }

    @Override
    public SidecarState buildLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1).build();
    }

    @Override
    public SidecarState buildMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
        for (SidecarStateBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
        for (SidecarStateBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSidecars(List<SidecarState> sidecars) {
        if (this.sidecars != null) {
            this._visitables.get((Object)"sidecars").clear();
        }
        if (sidecars != null) {
            this.sidecars = new ArrayList();
            for (SidecarState item : sidecars) {
                this.addToSidecars(item);
            }
        } else {
            this.sidecars = null;
        }
        return (A)this;
    }

    @Override
    public A withSidecars(SidecarState ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
            this._visitables.remove((Object)"sidecars");
        }
        if (sidecars != null) {
            for (SidecarState item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> addNewSidecar() {
        return new SidecarsNestedImpl();
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> addNewSidecarLike(SidecarState item) {
        return new SidecarsNestedImpl(-1, item);
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> setNewSidecarLike(int index, SidecarState item) {
        return new SidecarsNestedImpl(index, item);
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> editSidecar(int index) {
        if (this.sidecars.size() <= index) {
            throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> editFirstSidecar() {
        if (this.sidecars.size() == 0) {
            throw new RuntimeException("Can't edit first sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(0, this.buildSidecar(0));
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> editLastSidecar() {
        int index = this.sidecars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public TaskRunStatusFluent.SidecarsNested<A> editMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecars.size(); ++i) {
            if (!predicate.test(this.sidecars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecars. No match found.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public A addToSpanContext(String key, String value) {
        if (this.spanContext == null && key != null && value != null) {
            this.spanContext = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.spanContext.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSpanContext(Map<String, String> map) {
        if (this.spanContext == null && map != null) {
            this.spanContext = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.spanContext.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSpanContext(String key) {
        if (this.spanContext == null) {
            return (A)this;
        }
        if (key != null && this.spanContext != null) {
            this.spanContext.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSpanContext(Map<String, String> map) {
        if (this.spanContext == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.spanContext == null) continue;
                this.spanContext.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSpanContext() {
        return this.spanContext;
    }

    @Override
    public <K, V> A withSpanContext(Map<String, String> spanContext) {
        this.spanContext = spanContext == null ? null : new LinkedHashMap<String, String>(spanContext);
        return (A)this;
    }

    @Override
    public Boolean hasSpanContext() {
        return this.spanContext != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public A addToSteps(int index, StepState item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepStateBuilder builder = new StepStateBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").add(index, builder);
            this.steps.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSteps(int index, StepState item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepStateBuilder builder = new StepStateBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").set(index, builder);
            this.steps.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSteps(StepState ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<StepState> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(StepState ... items) {
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<StepState> items) {
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSteps(Predicate<StepStateBuilder> predicate) {
        if (this.steps == null) {
            return (A)this;
        }
        Iterator<StepStateBuilder> each = this.steps.iterator();
        List visitables = this._visitables.get((Object)"steps");
        while (each.hasNext()) {
            StepStateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StepState> getSteps() {
        return this.steps != null ? TaskRunStatusFluentImpl.build(this.steps) : null;
    }

    @Override
    public List<StepState> buildSteps() {
        return this.steps != null ? TaskRunStatusFluentImpl.build(this.steps) : null;
    }

    @Override
    public StepState buildStep(int index) {
        return this.steps.get(index).build();
    }

    @Override
    public StepState buildFirstStep() {
        return this.steps.get(0).build();
    }

    @Override
    public StepState buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    @Override
    public StepState buildMatchingStep(Predicate<StepStateBuilder> predicate) {
        for (StepStateBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<StepStateBuilder> predicate) {
        for (StepStateBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<StepState> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").clear();
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (StepState item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    @Override
    public A withSteps(StepState ... steps) {
        if (this.steps != null) {
            this.steps.clear();
            this._visitables.remove((Object)"steps");
        }
        if (steps != null) {
            for (StepState item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> addNewStep() {
        return new StepsNestedImpl();
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> addNewStepLike(StepState item) {
        return new StepsNestedImpl(-1, item);
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> setNewStepLike(int index, StepState item) {
        return new StepsNestedImpl(index, item);
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskRunStatusFluent.StepsNested<A> editMatchingStep(Predicate<StepStateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    @Deprecated
    public TaskSpec getTaskSpec() {
        return this.taskSpec != null ? this.taskSpec.build() : null;
    }

    @Override
    public TaskSpec buildTaskSpec() {
        return this.taskSpec != null ? this.taskSpec.build() : null;
    }

    @Override
    public A withTaskSpec(TaskSpec taskSpec) {
        this._visitables.get((Object)"taskSpec").remove(this.taskSpec);
        if (taskSpec != null) {
            this.taskSpec = new TaskSpecBuilder(taskSpec);
            this._visitables.get((Object)"taskSpec").add(this.taskSpec);
        } else {
            this.taskSpec = null;
            this._visitables.get((Object)"taskSpec").remove(this.taskSpec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaskSpec() {
        return this.taskSpec != null;
    }

    @Override
    public TaskRunStatusFluent.TaskSpecNested<A> withNewTaskSpec() {
        return new TaskSpecNestedImpl();
    }

    @Override
    public TaskRunStatusFluent.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
        return new TaskSpecNestedImpl(item);
    }

    @Override
    public TaskRunStatusFluent.TaskSpecNested<A> editTaskSpec() {
        return this.withNewTaskSpecLike(this.getTaskSpec());
    }

    @Override
    public TaskRunStatusFluent.TaskSpecNested<A> editOrNewTaskSpec() {
        return this.withNewTaskSpecLike(this.getTaskSpec() != null ? this.getTaskSpec() : new TaskSpecBuilder().build());
    }

    @Override
    public TaskRunStatusFluent.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
        return this.withNewTaskSpecLike(this.getTaskSpec() != null ? this.getTaskSpec() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskRunStatusFluentImpl that = (TaskRunStatusFluentImpl)o;
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.completionTime, that.completionTime)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.podName, that.podName)) {
            return false;
        }
        if (!Objects.equals(this.provenance, that.provenance)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.retriesStatus, that.retriesStatus)) {
            return false;
        }
        if (!Objects.equals(this.sidecars, that.sidecars)) {
            return false;
        }
        if (!Objects.equals(this.spanContext, that.spanContext)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.steps, that.steps)) {
            return false;
        }
        return Objects.equals(this.taskSpec, that.taskSpec);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.completionTime, this.conditions, this.observedGeneration, this.podName, this.provenance, this.results, this.retriesStatus, this.sidecars, this.spanContext, this.startTime, this.steps, this.taskSpec, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.podName != null) {
            sb.append("podName:");
            sb.append(this.podName + ",");
        }
        if (this.provenance != null) {
            sb.append("provenance:");
            sb.append(this.provenance + ",");
        }
        if (this.results != null) {
            sb.append("results:");
            sb.append(this.results + ",");
        }
        if (this.retriesStatus != null) {
            sb.append("retriesStatus:");
            sb.append(this.retriesStatus + ",");
        }
        if (this.sidecars != null) {
            sb.append("sidecars:");
            sb.append(this.sidecars + ",");
        }
        if (this.spanContext != null && !this.spanContext.isEmpty()) {
            sb.append("spanContext:");
            sb.append(this.spanContext + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.steps != null) {
            sb.append("steps:");
            sb.append(this.steps + ",");
        }
        if (this.taskSpec != null) {
            sb.append("taskSpec:");
            sb.append(this.taskSpec);
        }
        sb.append("}");
        return sb.toString();
    }

    class TaskSpecNestedImpl<N>
    extends TaskSpecFluentImpl<TaskRunStatusFluent.TaskSpecNested<N>>
    implements TaskRunStatusFluent.TaskSpecNested<N>,
    Nested<N> {
        TaskSpecBuilder builder;

        TaskSpecNestedImpl(TaskSpec item) {
            this.builder = new TaskSpecBuilder(this, item);
        }

        TaskSpecNestedImpl() {
            this.builder = new TaskSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunStatusFluentImpl.this.withTaskSpec(this.builder.build());
        }

        @Override
        public N endTaskSpec() {
            return this.and();
        }
    }

    class StepsNestedImpl<N>
    extends StepStateFluentImpl<TaskRunStatusFluent.StepsNested<N>>
    implements TaskRunStatusFluent.StepsNested<N>,
    Nested<N> {
        StepStateBuilder builder;
        int index;

        StepsNestedImpl(int index, StepState item) {
            this.index = index;
            this.builder = new StepStateBuilder(this, item);
        }

        StepsNestedImpl() {
            this.index = -1;
            this.builder = new StepStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunStatusFluentImpl.this.setToSteps(this.index, this.builder.build());
        }

        @Override
        public N endStep() {
            return this.and();
        }
    }

    class SidecarsNestedImpl<N>
    extends SidecarStateFluentImpl<TaskRunStatusFluent.SidecarsNested<N>>
    implements TaskRunStatusFluent.SidecarsNested<N>,
    Nested<N> {
        SidecarStateBuilder builder;
        int index;

        SidecarsNestedImpl(int index, SidecarState item) {
            this.index = index;
            this.builder = new SidecarStateBuilder(this, item);
        }

        SidecarsNestedImpl() {
            this.index = -1;
            this.builder = new SidecarStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunStatusFluentImpl.this.setToSidecars(this.index, this.builder.build());
        }

        @Override
        public N endSidecar() {
            return this.and();
        }
    }

    class RetriesStatusNestedImpl<N>
    extends TaskRunStatusFluentImpl<TaskRunStatusFluent.RetriesStatusNested<N>>
    implements TaskRunStatusFluent.RetriesStatusNested<N>,
    Nested<N> {
        TaskRunStatusBuilder builder;
        int index;

        RetriesStatusNestedImpl(int index, TaskRunStatus item) {
            this.index = index;
            this.builder = new TaskRunStatusBuilder(this, item);
        }

        RetriesStatusNestedImpl() {
            this.index = -1;
            this.builder = new TaskRunStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunStatusFluentImpl.this.setToRetriesStatus(this.index, this.builder.build());
        }

        @Override
        public N endRetriesStatus() {
            return this.and();
        }
    }

    class ResultsNestedImpl<N>
    extends TaskRunResultFluentImpl<TaskRunStatusFluent.ResultsNested<N>>
    implements TaskRunStatusFluent.ResultsNested<N>,
    Nested<N> {
        TaskRunResultBuilder builder;
        int index;

        ResultsNestedImpl(int index, TaskRunResult item) {
            this.index = index;
            this.builder = new TaskRunResultBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.index = -1;
            this.builder = new TaskRunResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunStatusFluentImpl.this.setToResults(this.index, this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }

    class ProvenanceNestedImpl<N>
    extends ProvenanceFluentImpl<TaskRunStatusFluent.ProvenanceNested<N>>
    implements TaskRunStatusFluent.ProvenanceNested<N>,
    Nested<N> {
        ProvenanceBuilder builder;

        ProvenanceNestedImpl(Provenance item) {
            this.builder = new ProvenanceBuilder(this, item);
        }

        ProvenanceNestedImpl() {
            this.builder = new ProvenanceBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunStatusFluentImpl.this.withProvenance(this.builder.build());
        }

        @Override
        public N endProvenance() {
            return this.and();
        }
    }
}

