/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.ProjectedVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.tekton.pipeline.v1.WorkspaceBinding;
import io.fabric8.tekton.pipeline.v1.WorkspaceBindingFluent;
import java.util.Objects;

public class WorkspaceBindingFluentImpl<A extends WorkspaceBindingFluent<A>>
extends BaseFluent<A>
implements WorkspaceBindingFluent<A> {
    private ConfigMapVolumeSource configMap;
    private CSIVolumeSource csi;
    private EmptyDirVolumeSource emptyDir;
    private String name;
    private PersistentVolumeClaimVolumeSource persistentVolumeClaim;
    private ProjectedVolumeSource projected;
    private SecretVolumeSource secret;
    private String subPath;
    private PersistentVolumeClaimBuilder volumeClaimTemplate;

    public WorkspaceBindingFluentImpl() {
    }

    public WorkspaceBindingFluentImpl(WorkspaceBinding instance) {
        if (instance != null) {
            this.withConfigMap(instance.getConfigMap());
            this.withCsi(instance.getCsi());
            this.withEmptyDir(instance.getEmptyDir());
            this.withName(instance.getName());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
            this.withProjected(instance.getProjected());
            this.withSecret(instance.getSecret());
            this.withSubPath(instance.getSubPath());
            this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
        }
    }

    @Override
    public ConfigMapVolumeSource getConfigMap() {
        return this.configMap;
    }

    @Override
    public A withConfigMap(ConfigMapVolumeSource configMap) {
        this.configMap = configMap;
        return (A)this;
    }

    @Override
    public Boolean hasConfigMap() {
        return this.configMap != null;
    }

    @Override
    public CSIVolumeSource getCsi() {
        return this.csi;
    }

    @Override
    public A withCsi(CSIVolumeSource csi) {
        this.csi = csi;
        return (A)this;
    }

    @Override
    public Boolean hasCsi() {
        return this.csi != null;
    }

    @Override
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    @Override
    public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
        return (A)this;
    }

    @Override
    public Boolean hasEmptyDir() {
        return this.emptyDir != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    @Override
    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
        return (A)this;
    }

    @Override
    public Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    @Override
    public A withNewPersistentVolumeClaim(String claimName, Boolean readOnly) {
        return this.withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    @Override
    public ProjectedVolumeSource getProjected() {
        return this.projected;
    }

    @Override
    public A withProjected(ProjectedVolumeSource projected) {
        this.projected = projected;
        return (A)this;
    }

    @Override
    public Boolean hasProjected() {
        return this.projected != null;
    }

    @Override
    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    @Override
    public A withSecret(SecretVolumeSource secret) {
        this.secret = secret;
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public String getSubPath() {
        return this.subPath;
    }

    @Override
    public A withSubPath(String subPath) {
        this.subPath = subPath;
        return (A)this;
    }

    @Override
    public Boolean hasSubPath() {
        return this.subPath != null;
    }

    @Override
    @Deprecated
    public PersistentVolumeClaim getVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public PersistentVolumeClaim buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public A withVolumeClaimTemplate(PersistentVolumeClaim volumeClaimTemplate) {
        this._visitables.get((Object)"volumeClaimTemplate").remove(this.volumeClaimTemplate);
        if (volumeClaimTemplate != null) {
            this.volumeClaimTemplate = new PersistentVolumeClaimBuilder(volumeClaimTemplate);
            this._visitables.get((Object)"volumeClaimTemplate").add(this.volumeClaimTemplate);
        } else {
            this.volumeClaimTemplate = null;
            this._visitables.get((Object)"volumeClaimTemplate").remove(this.volumeClaimTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    @Override
    public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNestedImpl();
    }

    @Override
    public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
        return new VolumeClaimTemplateNestedImpl(item);
    }

    @Override
    public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate());
    }

    @Override
    public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : new PersistentVolumeClaimBuilder().build());
    }

    @Override
    public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorkspaceBindingFluentImpl that = (WorkspaceBindingFluentImpl)o;
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.csi, that.csi)) {
            return false;
        }
        if (!Objects.equals(this.emptyDir, that.emptyDir)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.persistentVolumeClaim, that.persistentVolumeClaim)) {
            return false;
        }
        if (!Objects.equals(this.projected, that.projected)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.subPath, that.subPath)) {
            return false;
        }
        return Objects.equals(this.volumeClaimTemplate, that.volumeClaimTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.configMap, this.csi, this.emptyDir, this.name, this.persistentVolumeClaim, this.projected, this.secret, this.subPath, this.volumeClaimTemplate, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap + ",");
        }
        if (this.csi != null) {
            sb.append("csi:");
            sb.append(this.csi + ",");
        }
        if (this.emptyDir != null) {
            sb.append("emptyDir:");
            sb.append(this.emptyDir + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(this.persistentVolumeClaim + ",");
        }
        if (this.projected != null) {
            sb.append("projected:");
            sb.append(this.projected + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.subPath != null) {
            sb.append("subPath:");
            sb.append(this.subPath + ",");
        }
        if (this.volumeClaimTemplate != null) {
            sb.append("volumeClaimTemplate:");
            sb.append(this.volumeClaimTemplate);
        }
        sb.append("}");
        return sb.toString();
    }

    class VolumeClaimTemplateNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<WorkspaceBindingFluent.VolumeClaimTemplateNested<N>>
    implements WorkspaceBindingFluent.VolumeClaimTemplateNested<N>,
    Nested<N> {
        PersistentVolumeClaimBuilder builder;

        VolumeClaimTemplateNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder((PersistentVolumeClaimFluent)this, item);
        }

        VolumeClaimTemplateNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder((PersistentVolumeClaimFluent)this);
        }

        @Override
        public N and() {
            return (N)WorkspaceBindingFluentImpl.this.withVolumeClaimTemplate(this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }
}

