package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChildStatusReferenceBuilder extends ChildStatusReferenceFluentImpl<ChildStatusReferenceBuilder> implements VisitableBuilder<ChildStatusReference,ChildStatusReferenceBuilder>{
  public ChildStatusReferenceBuilder() {
    this(false);
  }
  public ChildStatusReferenceBuilder(Boolean validationEnabled) {
    this(new ChildStatusReference(), validationEnabled);
  }
  public ChildStatusReferenceBuilder(ChildStatusReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ChildStatusReferenceBuilder(ChildStatusReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChildStatusReference(), validationEnabled);
  }
  public ChildStatusReferenceBuilder(ChildStatusReferenceFluent<?> fluent,ChildStatusReference instance) {
    this(fluent, instance, false);
  }
  public ChildStatusReferenceBuilder(ChildStatusReferenceFluent<?> fluent,ChildStatusReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withPipelineTaskName(instance.getPipelineTaskName());
      fluent.withWhenExpressions(instance.getWhenExpressions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChildStatusReferenceBuilder(ChildStatusReference instance) {
    this(instance,false);
  }
  public ChildStatusReferenceBuilder(ChildStatusReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withPipelineTaskName(instance.getPipelineTaskName());
      this.withWhenExpressions(instance.getWhenExpressions());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChildStatusReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ChildStatusReference build() {
    ChildStatusReference buildable = new ChildStatusReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getPipelineTaskName(),fluent.getWhenExpressions());
    return buildable;
  }
  
}