package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EmbeddedTaskBuilder extends EmbeddedTaskFluentImpl<EmbeddedTaskBuilder> implements VisitableBuilder<EmbeddedTask,EmbeddedTaskBuilder>{
  public EmbeddedTaskBuilder() {
    this(false);
  }
  public EmbeddedTaskBuilder(Boolean validationEnabled) {
    this(new EmbeddedTask(), validationEnabled);
  }
  public EmbeddedTaskBuilder(EmbeddedTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public EmbeddedTaskBuilder(EmbeddedTaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EmbeddedTask(), validationEnabled);
  }
  public EmbeddedTaskBuilder(EmbeddedTaskFluent<?> fluent,EmbeddedTask instance) {
    this(fluent, instance, false);
  }
  public EmbeddedTaskBuilder(EmbeddedTaskFluent<?> fluent,EmbeddedTask instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withParams(instance.getParams());
      fluent.withResults(instance.getResults());
      fluent.withSidecars(instance.getSidecars());
      fluent.withSpec(instance.getSpec());
      fluent.withStepTemplate(instance.getStepTemplate());
      fluent.withSteps(instance.getSteps());
      fluent.withVolumes(instance.getVolumes());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EmbeddedTaskBuilder(EmbeddedTask instance) {
    this(instance,false);
  }
  public EmbeddedTaskBuilder(EmbeddedTask instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withParams(instance.getParams());
      this.withResults(instance.getResults());
      this.withSidecars(instance.getSidecars());
      this.withSpec(instance.getSpec());
      this.withStepTemplate(instance.getStepTemplate());
      this.withSteps(instance.getSteps());
      this.withVolumes(instance.getVolumes());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  EmbeddedTaskFluent<?> fluent;
  Boolean validationEnabled;
  public EmbeddedTask build() {
    EmbeddedTask buildable = new EmbeddedTask(fluent.getApiVersion(),fluent.getDescription(),fluent.getDisplayName(),fluent.getKind(),fluent.getMetadata(),fluent.getParams(),fluent.getResults(),fluent.getSidecars(),fluent.getSpec(),fluent.getStepTemplate(),fluent.getSteps(),fluent.getVolumes(),fluent.getWorkspaces());
    return buildable;
  }
  
}