package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MatrixBuilder extends MatrixFluentImpl<MatrixBuilder> implements VisitableBuilder<Matrix,MatrixBuilder>{
  public MatrixBuilder() {
    this(false);
  }
  public MatrixBuilder(Boolean validationEnabled) {
    this(new Matrix(), validationEnabled);
  }
  public MatrixBuilder(MatrixFluent<?> fluent) {
    this(fluent, false);
  }
  public MatrixBuilder(MatrixFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Matrix(), validationEnabled);
  }
  public MatrixBuilder(MatrixFluent<?> fluent,Matrix instance) {
    this(fluent, instance, false);
  }
  public MatrixBuilder(MatrixFluent<?> fluent,Matrix instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withInclude(instance.getInclude());
      fluent.withParams(instance.getParams());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MatrixBuilder(Matrix instance) {
    this(instance,false);
  }
  public MatrixBuilder(Matrix instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withInclude(instance.getInclude());
      this.withParams(instance.getParams());
    }
    this.validationEnabled = validationEnabled; 
  }
  MatrixFluent<?> fluent;
  Boolean validationEnabled;
  public Matrix build() {
    Matrix buildable = new Matrix(fluent.getInclude(),fluent.getParams());
    return buildable;
  }
  
}