package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParamSpecBuilder extends ParamSpecFluentImpl<ParamSpecBuilder> implements VisitableBuilder<ParamSpec,ParamSpecBuilder>{
  public ParamSpecBuilder() {
    this(false);
  }
  public ParamSpecBuilder(Boolean validationEnabled) {
    this(new ParamSpec(), validationEnabled);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParamSpec(), validationEnabled);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance) {
    this(fluent, instance, false);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDefault(instance.getDefault());
      fluent.withDescription(instance.getDescription());
      fluent.withName(instance.getName());
      fluent.withProperties(instance.getProperties());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParamSpecBuilder(ParamSpec instance) {
    this(instance,false);
  }
  public ParamSpecBuilder(ParamSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDefault(instance.getDefault());
      this.withDescription(instance.getDescription());
      this.withName(instance.getName());
      this.withProperties(instance.getProperties());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParamSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ParamSpec build() {
    ParamSpec buildable = new ParamSpec(fluent.getDefault(),fluent.getDescription(),fluent.getName(),fluent.getProperties(),fluent.getType());
    return buildable;
  }
  
}