package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineBuilder extends PipelineFluentImpl<PipelineBuilder> implements VisitableBuilder<Pipeline,PipelineBuilder>{
  public PipelineBuilder() {
    this(false);
  }
  public PipelineBuilder(Boolean validationEnabled) {
    this(new Pipeline(), validationEnabled);
  }
  public PipelineBuilder(PipelineFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineBuilder(PipelineFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Pipeline(), validationEnabled);
  }
  public PipelineBuilder(PipelineFluent<?> fluent,Pipeline instance) {
    this(fluent, instance, false);
  }
  public PipelineBuilder(PipelineFluent<?> fluent,Pipeline instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineBuilder(Pipeline instance) {
    this(instance,false);
  }
  public PipelineBuilder(Pipeline instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineFluent<?> fluent;
  Boolean validationEnabled;
  public Pipeline build() {
    Pipeline buildable = new Pipeline(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  
}