package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineResultBuilder extends PipelineResultFluentImpl<PipelineResultBuilder> implements VisitableBuilder<PipelineResult,PipelineResultBuilder>{
  public PipelineResultBuilder() {
    this(false);
  }
  public PipelineResultBuilder(Boolean validationEnabled) {
    this(new PipelineResult(), validationEnabled);
  }
  public PipelineResultBuilder(PipelineResultFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineResultBuilder(PipelineResultFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineResult(), validationEnabled);
  }
  public PipelineResultBuilder(PipelineResultFluent<?> fluent,PipelineResult instance) {
    this(fluent, instance, false);
  }
  public PipelineResultBuilder(PipelineResultFluent<?> fluent,PipelineResult instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withName(instance.getName());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineResultBuilder(PipelineResult instance) {
    this(instance,false);
  }
  public PipelineResultBuilder(PipelineResult instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withName(instance.getName());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineResultFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineResult build() {
    PipelineResult buildable = new PipelineResult(fluent.getDescription(),fluent.getName(),fluent.getType(),fluent.getValue());
    return buildable;
  }
  
}