package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineRunStatusBuilder extends PipelineRunStatusFluentImpl<PipelineRunStatusBuilder> implements VisitableBuilder<PipelineRunStatus,PipelineRunStatusBuilder>{
  public PipelineRunStatusBuilder() {
    this(false);
  }
  public PipelineRunStatusBuilder(Boolean validationEnabled) {
    this(new PipelineRunStatus(), validationEnabled);
  }
  public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineRunStatus(), validationEnabled);
  }
  public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,PipelineRunStatus instance) {
    this(fluent, instance, false);
  }
  public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,PipelineRunStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withChildReferences(instance.getChildReferences());
      fluent.withCompletionTime(instance.getCompletionTime());
      fluent.withConditions(instance.getConditions());
      fluent.withFinallyStartTime(instance.getFinallyStartTime());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPipelineSpec(instance.getPipelineSpec());
      fluent.withProvenance(instance.getProvenance());
      fluent.withResults(instance.getResults());
      fluent.withSkippedTasks(instance.getSkippedTasks());
      fluent.withSpanContext(instance.getSpanContext());
      fluent.withStartTime(instance.getStartTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineRunStatusBuilder(PipelineRunStatus instance) {
    this(instance,false);
  }
  public PipelineRunStatusBuilder(PipelineRunStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withChildReferences(instance.getChildReferences());
      this.withCompletionTime(instance.getCompletionTime());
      this.withConditions(instance.getConditions());
      this.withFinallyStartTime(instance.getFinallyStartTime());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPipelineSpec(instance.getPipelineSpec());
      this.withProvenance(instance.getProvenance());
      this.withResults(instance.getResults());
      this.withSkippedTasks(instance.getSkippedTasks());
      this.withSpanContext(instance.getSpanContext());
      this.withStartTime(instance.getStartTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineRunStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineRunStatus build() {
    PipelineRunStatus buildable = new PipelineRunStatus(fluent.getAnnotations(),fluent.getChildReferences(),fluent.getCompletionTime(),fluent.getConditions(),fluent.getFinallyStartTime(),fluent.getObservedGeneration(),fluent.getPipelineSpec(),fluent.getProvenance(),fluent.getResults(),fluent.getSkippedTasks(),fluent.getSpanContext(),fluent.getStartTime());
    return buildable;
  }
  
}