package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PipelineTaskFluentImpl<A extends PipelineTaskFluent<A>> extends BaseFluent<A> implements PipelineTaskFluent<A>{
  public PipelineTaskFluentImpl() {
  }
  public PipelineTaskFluentImpl(PipelineTask instance) {
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withMatrix(instance.getMatrix());
      this.withName(instance.getName());
      this.withParams(instance.getParams());
      this.withRetries(instance.getRetries());
      this.withRunAfter(instance.getRunAfter());
      this.withTaskRef(instance.getTaskRef());
      this.withTaskSpec(instance.getTaskSpec());
      this.withTimeout(instance.getTimeout());
      this.withWhen(instance.getWhen());
      this.withWorkspaces(instance.getWorkspaces());
    }
  }
  private String description;
  private String displayName;
  private MatrixBuilder matrix;
  private String name;
  private ArrayList<ParamBuilder> params = new ArrayList<ParamBuilder>();
  private Integer retries;
  private List<String> runAfter = new ArrayList<String>();
  private TaskRefBuilder taskRef;
  private EmbeddedTaskBuilder taskSpec;
  private Duration timeout;
  private ArrayList<WhenExpressionBuilder> when = new ArrayList<WhenExpressionBuilder>();
  private ArrayList<WorkspacePipelineTaskBindingBuilder> workspaces = new ArrayList<WorkspacePipelineTaskBindingBuilder>();
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public Boolean hasDisplayName() {
    return this.displayName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMatrix instead.
   * @return The buildable object.
   */
  @Deprecated
  public Matrix getMatrix() {
    return this.matrix!=null ?this.matrix.build():null;
  }
  public Matrix buildMatrix() {
    return this.matrix!=null ?this.matrix.build():null;
  }
  public A withMatrix(Matrix matrix) {
    _visitables.get("matrix").remove(this.matrix);
    if (matrix!=null){ this.matrix= new MatrixBuilder(matrix); _visitables.get("matrix").add(this.matrix);} else { this.matrix = null; _visitables.get("matrix").remove(this.matrix); } return (A) this;
  }
  public Boolean hasMatrix() {
    return this.matrix != null;
  }
  public PipelineTaskFluentImpl.MatrixNested<A> withNewMatrix() {
    return new PipelineTaskFluentImpl.MatrixNestedImpl();
  }
  public PipelineTaskFluentImpl.MatrixNested<A> withNewMatrixLike(Matrix item) {
    return new PipelineTaskFluentImpl.MatrixNestedImpl(item);
  }
  public PipelineTaskFluentImpl.MatrixNested<A> editMatrix() {
    return withNewMatrixLike(getMatrix());
  }
  public PipelineTaskFluentImpl.MatrixNested<A> editOrNewMatrix() {
    return withNewMatrixLike(getMatrix() != null ? getMatrix(): new MatrixBuilder().build());
  }
  public PipelineTaskFluentImpl.MatrixNested<A> editOrNewMatrixLike(Matrix item) {
    return withNewMatrixLike(getMatrix() != null ? getMatrix(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  public A setToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  public A addToParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A addAllToParams(Collection<Param> items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A removeFromParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeAllFromParams(Collection<Param> items) {
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Param> getParams() {
    return params != null ? build(params) : null;
  }
  public List<Param> buildParams() {
    return params != null ? build(params) : null;
  }
  public Param buildParam(int index) {
    return this.params.get(index).build();
  }
  public Param buildFirstParam() {
    return this.params.get(0).build();
  }
  public Param buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
    for (ParamBuilder item: params) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
    for (ParamBuilder item: params) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParams(List<Param> params) {
    if (this.params != null) { _visitables.get("params").clear();}
    if (params != null) {this.params = new ArrayList(); for (Param item : params){this.addToParams(item);}} else { this.params = null;} return (A) this;
  }
  public A withParams(io.fabric8.tekton.pipeline.v1.Param... params) {
    if (this.params != null) {this.params.clear(); _visitables.remove("params"); }
    if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
  }
  public Boolean hasParams() {
    return params != null && !params.isEmpty();
  }
  public PipelineTaskFluentImpl.ParamsNested<A> addNewParam() {
    return new PipelineTaskFluentImpl.ParamsNestedImpl();
  }
  public PipelineTaskFluentImpl.ParamsNested<A> addNewParamLike(Param item) {
    return new PipelineTaskFluentImpl.ParamsNestedImpl(-1, item);
  }
  public PipelineTaskFluentImpl.ParamsNested<A> setNewParamLike(int index,Param item) {
    return new PipelineTaskFluentImpl.ParamsNestedImpl(index, item);
  }
  public PipelineTaskFluentImpl.ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  public PipelineTaskFluentImpl.ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  public PipelineTaskFluentImpl.ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  public PipelineTaskFluentImpl.ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  public Integer getRetries() {
    return this.retries;
  }
  public A withRetries(Integer retries) {
    this.retries=retries; return (A) this;
  }
  public Boolean hasRetries() {
    return this.retries != null;
  }
  public A addToRunAfter(int index,String item) {
    if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
    this.runAfter.add(index, item);
    return (A)this;
  }
  public A setToRunAfter(int index,String item) {
    if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
    this.runAfter.set(index, item); return (A)this;
  }
  public A addToRunAfter(java.lang.String... items) {
    if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
    for (String item : items) {this.runAfter.add(item);} return (A)this;
  }
  public A addAllToRunAfter(Collection<String> items) {
    if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
    for (String item : items) {this.runAfter.add(item);} return (A)this;
  }
  public A removeFromRunAfter(java.lang.String... items) {
    for (String item : items) {if (this.runAfter!= null){ this.runAfter.remove(item);}} return (A)this;
  }
  public A removeAllFromRunAfter(Collection<String> items) {
    for (String item : items) {if (this.runAfter!= null){ this.runAfter.remove(item);}} return (A)this;
  }
  public List<String> getRunAfter() {
    return this.runAfter;
  }
  public String getRunAfter(int index) {
    return this.runAfter.get(index);
  }
  public String getFirstRunAfter() {
    return this.runAfter.get(0);
  }
  public String getLastRunAfter() {
    return this.runAfter.get(runAfter.size() - 1);
  }
  public String getMatchingRunAfter(Predicate<String> predicate) {
    for (String item: runAfter) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRunAfter(Predicate<String> predicate) {
    for (String item: runAfter) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRunAfter(List<String> runAfter) {
    if (runAfter != null) {this.runAfter = new ArrayList(); for (String item : runAfter){this.addToRunAfter(item);}} else { this.runAfter = null;} return (A) this;
  }
  public A withRunAfter(java.lang.String... runAfter) {
    if (this.runAfter != null) {this.runAfter.clear(); _visitables.remove("runAfter"); }
    if (runAfter != null) {for (String item :runAfter){ this.addToRunAfter(item);}} return (A) this;
  }
  public Boolean hasRunAfter() {
    return runAfter != null && !runAfter.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildTaskRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public TaskRef getTaskRef() {
    return this.taskRef!=null ?this.taskRef.build():null;
  }
  public TaskRef buildTaskRef() {
    return this.taskRef!=null ?this.taskRef.build():null;
  }
  public A withTaskRef(TaskRef taskRef) {
    _visitables.get("taskRef").remove(this.taskRef);
    if (taskRef!=null){ this.taskRef= new TaskRefBuilder(taskRef); _visitables.get("taskRef").add(this.taskRef);} else { this.taskRef = null; _visitables.get("taskRef").remove(this.taskRef); } return (A) this;
  }
  public Boolean hasTaskRef() {
    return this.taskRef != null;
  }
  public PipelineTaskFluentImpl.TaskRefNested<A> withNewTaskRef() {
    return new PipelineTaskFluentImpl.TaskRefNestedImpl();
  }
  public PipelineTaskFluentImpl.TaskRefNested<A> withNewTaskRefLike(TaskRef item) {
    return new PipelineTaskFluentImpl.TaskRefNestedImpl(item);
  }
  public PipelineTaskFluentImpl.TaskRefNested<A> editTaskRef() {
    return withNewTaskRefLike(getTaskRef());
  }
  public PipelineTaskFluentImpl.TaskRefNested<A> editOrNewTaskRef() {
    return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): new TaskRefBuilder().build());
  }
  public PipelineTaskFluentImpl.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item) {
    return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTaskSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedTask getTaskSpec() {
    return this.taskSpec!=null ?this.taskSpec.build():null;
  }
  public EmbeddedTask buildTaskSpec() {
    return this.taskSpec!=null ?this.taskSpec.build():null;
  }
  public A withTaskSpec(EmbeddedTask taskSpec) {
    _visitables.get("taskSpec").remove(this.taskSpec);
    if (taskSpec!=null){ this.taskSpec= new EmbeddedTaskBuilder(taskSpec); _visitables.get("taskSpec").add(this.taskSpec);} else { this.taskSpec = null; _visitables.get("taskSpec").remove(this.taskSpec); } return (A) this;
  }
  public Boolean hasTaskSpec() {
    return this.taskSpec != null;
  }
  public PipelineTaskFluentImpl.TaskSpecNested<A> withNewTaskSpec() {
    return new PipelineTaskFluentImpl.TaskSpecNestedImpl();
  }
  public PipelineTaskFluentImpl.TaskSpecNested<A> withNewTaskSpecLike(EmbeddedTask item) {
    return new PipelineTaskFluentImpl.TaskSpecNestedImpl(item);
  }
  public PipelineTaskFluentImpl.TaskSpecNested<A> editTaskSpec() {
    return withNewTaskSpecLike(getTaskSpec());
  }
  public PipelineTaskFluentImpl.TaskSpecNested<A> editOrNewTaskSpec() {
    return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): new EmbeddedTaskBuilder().build());
  }
  public PipelineTaskFluentImpl.TaskSpecNested<A> editOrNewTaskSpecLike(EmbeddedTask item) {
    return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): item);
  }
  public Duration getTimeout() {
    return this.timeout;
  }
  public A withTimeout(Duration timeout) {
    this.timeout=timeout; return (A) this;
  }
  public Boolean hasTimeout() {
    return this.timeout != null;
  }
  public A addToWhen(int index,WhenExpression item) {
    if (this.when == null) {this.when = new ArrayList<WhenExpressionBuilder>();}
    WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
    if (index < 0 || index >= when.size()) { _visitables.get("when").add(builder); when.add(builder); } else { _visitables.get("when").add(index, builder); when.add(index, builder);}
    return (A)this;
  }
  public A setToWhen(int index,WhenExpression item) {
    if (this.when == null) {this.when = new ArrayList<WhenExpressionBuilder>();}
    WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
    if (index < 0 || index >= when.size()) { _visitables.get("when").add(builder); when.add(builder); } else { _visitables.get("when").set(index, builder); when.set(index, builder);}
    return (A)this;
  }
  public A addToWhen(io.fabric8.tekton.pipeline.v1.WhenExpression... items) {
    if (this.when == null) {this.when = new ArrayList<WhenExpressionBuilder>();}
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("when").add(builder);this.when.add(builder);} return (A)this;
  }
  public A addAllToWhen(Collection<WhenExpression> items) {
    if (this.when == null) {this.when = new ArrayList<WhenExpressionBuilder>();}
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("when").add(builder);this.when.add(builder);} return (A)this;
  }
  public A removeFromWhen(io.fabric8.tekton.pipeline.v1.WhenExpression... items) {
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("when").remove(builder);if (this.when != null) {this.when.remove(builder);}} return (A)this;
  }
  public A removeAllFromWhen(Collection<WhenExpression> items) {
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("when").remove(builder);if (this.when != null) {this.when.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWhen(Predicate<WhenExpressionBuilder> predicate) {
    if (when == null) return (A) this;
    final Iterator<WhenExpressionBuilder> each = when.iterator();
    final List visitables = _visitables.get("when");
    while (each.hasNext()) {
      WhenExpressionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWhen instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WhenExpression> getWhen() {
    return when != null ? build(when) : null;
  }
  public List<WhenExpression> buildWhen() {
    return when != null ? build(when) : null;
  }
  public WhenExpression buildWhen(int index) {
    return this.when.get(index).build();
  }
  public WhenExpression buildFirstWhen() {
    return this.when.get(0).build();
  }
  public WhenExpression buildLastWhen() {
    return this.when.get(when.size() - 1).build();
  }
  public WhenExpression buildMatchingWhen(Predicate<WhenExpressionBuilder> predicate) {
    for (WhenExpressionBuilder item: when) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWhen(Predicate<WhenExpressionBuilder> predicate) {
    for (WhenExpressionBuilder item: when) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWhen(List<WhenExpression> when) {
    if (this.when != null) { _visitables.get("when").clear();}
    if (when != null) {this.when = new ArrayList(); for (WhenExpression item : when){this.addToWhen(item);}} else { this.when = null;} return (A) this;
  }
  public A withWhen(io.fabric8.tekton.pipeline.v1.WhenExpression... when) {
    if (this.when != null) {this.when.clear(); _visitables.remove("when"); }
    if (when != null) {for (WhenExpression item :when){ this.addToWhen(item);}} return (A) this;
  }
  public Boolean hasWhen() {
    return when != null && !when.isEmpty();
  }
  public PipelineTaskFluentImpl.WhenNested<A> addNewWhen() {
    return new PipelineTaskFluentImpl.WhenNestedImpl();
  }
  public PipelineTaskFluentImpl.WhenNested<A> addNewWhenLike(WhenExpression item) {
    return new PipelineTaskFluentImpl.WhenNestedImpl(-1, item);
  }
  public PipelineTaskFluentImpl.WhenNested<A> setNewWhenLike(int index,WhenExpression item) {
    return new PipelineTaskFluentImpl.WhenNestedImpl(index, item);
  }
  public PipelineTaskFluentImpl.WhenNested<A> editWhen(int index) {
    if (when.size() <= index) throw new RuntimeException("Can't edit when. Index exceeds size.");
    return setNewWhenLike(index, buildWhen(index));
  }
  public PipelineTaskFluentImpl.WhenNested<A> editFirstWhen() {
    if (when.size() == 0) throw new RuntimeException("Can't edit first when. The list is empty.");
    return setNewWhenLike(0, buildWhen(0));
  }
  public PipelineTaskFluentImpl.WhenNested<A> editLastWhen() {
    int index = when.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last when. The list is empty.");
    return setNewWhenLike(index, buildWhen(index));
  }
  public PipelineTaskFluentImpl.WhenNested<A> editMatchingWhen(Predicate<WhenExpressionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<when.size();i++) { 
    if (predicate.test(when.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching when. No match found.");
    return setNewWhenLike(index, buildWhen(index));
  }
  public A addToWorkspaces(int index,WorkspacePipelineTaskBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspacePipelineTaskBindingBuilder>();}
    WorkspacePipelineTaskBindingBuilder builder = new WorkspacePipelineTaskBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").add(index, builder); workspaces.add(index, builder);}
    return (A)this;
  }
  public A setToWorkspaces(int index,WorkspacePipelineTaskBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspacePipelineTaskBindingBuilder>();}
    WorkspacePipelineTaskBindingBuilder builder = new WorkspacePipelineTaskBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").set(index, builder); workspaces.set(index, builder);}
    return (A)this;
  }
  public A addToWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspacePipelineTaskBinding... items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspacePipelineTaskBindingBuilder>();}
    for (WorkspacePipelineTaskBinding item : items) {WorkspacePipelineTaskBindingBuilder builder = new WorkspacePipelineTaskBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  public A addAllToWorkspaces(Collection<WorkspacePipelineTaskBinding> items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspacePipelineTaskBindingBuilder>();}
    for (WorkspacePipelineTaskBinding item : items) {WorkspacePipelineTaskBindingBuilder builder = new WorkspacePipelineTaskBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  public A removeFromWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspacePipelineTaskBinding... items) {
    for (WorkspacePipelineTaskBinding item : items) {WorkspacePipelineTaskBindingBuilder builder = new WorkspacePipelineTaskBindingBuilder(item);_visitables.get("workspaces").remove(builder);if (this.workspaces != null) {this.workspaces.remove(builder);}} return (A)this;
  }
  public A removeAllFromWorkspaces(Collection<WorkspacePipelineTaskBinding> items) {
    for (WorkspacePipelineTaskBinding item : items) {WorkspacePipelineTaskBindingBuilder builder = new WorkspacePipelineTaskBindingBuilder(item);_visitables.get("workspaces").remove(builder);if (this.workspaces != null) {this.workspaces.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWorkspaces(Predicate<WorkspacePipelineTaskBindingBuilder> predicate) {
    if (workspaces == null) return (A) this;
    final Iterator<WorkspacePipelineTaskBindingBuilder> each = workspaces.iterator();
    final List visitables = _visitables.get("workspaces");
    while (each.hasNext()) {
      WorkspacePipelineTaskBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWorkspaces instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WorkspacePipelineTaskBinding> getWorkspaces() {
    return workspaces != null ? build(workspaces) : null;
  }
  public List<WorkspacePipelineTaskBinding> buildWorkspaces() {
    return workspaces != null ? build(workspaces) : null;
  }
  public WorkspacePipelineTaskBinding buildWorkspace(int index) {
    return this.workspaces.get(index).build();
  }
  public WorkspacePipelineTaskBinding buildFirstWorkspace() {
    return this.workspaces.get(0).build();
  }
  public WorkspacePipelineTaskBinding buildLastWorkspace() {
    return this.workspaces.get(workspaces.size() - 1).build();
  }
  public WorkspacePipelineTaskBinding buildMatchingWorkspace(Predicate<WorkspacePipelineTaskBindingBuilder> predicate) {
    for (WorkspacePipelineTaskBindingBuilder item: workspaces) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWorkspace(Predicate<WorkspacePipelineTaskBindingBuilder> predicate) {
    for (WorkspacePipelineTaskBindingBuilder item: workspaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWorkspaces(List<WorkspacePipelineTaskBinding> workspaces) {
    if (this.workspaces != null) { _visitables.get("workspaces").clear();}
    if (workspaces != null) {this.workspaces = new ArrayList(); for (WorkspacePipelineTaskBinding item : workspaces){this.addToWorkspaces(item);}} else { this.workspaces = null;} return (A) this;
  }
  public A withWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspacePipelineTaskBinding... workspaces) {
    if (this.workspaces != null) {this.workspaces.clear(); _visitables.remove("workspaces"); }
    if (workspaces != null) {for (WorkspacePipelineTaskBinding item :workspaces){ this.addToWorkspaces(item);}} return (A) this;
  }
  public Boolean hasWorkspaces() {
    return workspaces != null && !workspaces.isEmpty();
  }
  public A addNewWorkspace(String name,String subPath,String workspace) {
    return (A)addToWorkspaces(new WorkspacePipelineTaskBinding(name, subPath, workspace));
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> addNewWorkspace() {
    return new PipelineTaskFluentImpl.WorkspacesNestedImpl();
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> addNewWorkspaceLike(WorkspacePipelineTaskBinding item) {
    return new PipelineTaskFluentImpl.WorkspacesNestedImpl(-1, item);
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> setNewWorkspaceLike(int index,WorkspacePipelineTaskBinding item) {
    return new PipelineTaskFluentImpl.WorkspacesNestedImpl(index, item);
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> editWorkspace(int index) {
    if (workspaces.size() <= index) throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> editFirstWorkspace() {
    if (workspaces.size() == 0) throw new RuntimeException("Can't edit first workspaces. The list is empty.");
    return setNewWorkspaceLike(0, buildWorkspace(0));
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> editLastWorkspace() {
    int index = workspaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last workspaces. The list is empty.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public PipelineTaskFluentImpl.WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspacePipelineTaskBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<workspaces.size();i++) { 
    if (predicate.test(workspaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching workspaces. No match found.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineTaskFluentImpl that = (PipelineTaskFluentImpl) o;
    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(matrix, that.matrix)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(params, that.params)) return false;

    if (!java.util.Objects.equals(retries, that.retries)) return false;

    if (!java.util.Objects.equals(runAfter, that.runAfter)) return false;

    if (!java.util.Objects.equals(taskRef, that.taskRef)) return false;

    if (!java.util.Objects.equals(taskSpec, that.taskSpec)) return false;

    if (!java.util.Objects.equals(timeout, that.timeout)) return false;

    if (!java.util.Objects.equals(when, that.when)) return false;

    if (!java.util.Objects.equals(workspaces, that.workspaces)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(description,  displayName,  matrix,  name,  params,  retries,  runAfter,  taskRef,  taskSpec,  timeout,  when,  workspaces,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (matrix != null) { sb.append("matrix:"); sb.append(matrix + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (params != null) { sb.append("params:"); sb.append(params + ","); }
    if (retries != null) { sb.append("retries:"); sb.append(retries + ","); }
    if (runAfter != null && !runAfter.isEmpty()) { sb.append("runAfter:"); sb.append(runAfter + ","); }
    if (taskRef != null) { sb.append("taskRef:"); sb.append(taskRef + ","); }
    if (taskSpec != null) { sb.append("taskSpec:"); sb.append(taskSpec + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (when != null) { sb.append("when:"); sb.append(when + ","); }
    if (workspaces != null) { sb.append("workspaces:"); sb.append(workspaces); }
    sb.append("}");
    return sb.toString();
  }
  class MatrixNestedImpl<N> extends MatrixFluentImpl<PipelineTaskFluentImpl.MatrixNested<N>> implements PipelineTaskFluentImpl.MatrixNested<N>,Nested<N>{
    MatrixNestedImpl(Matrix item) {
      this.builder = new MatrixBuilder(this, item);
    }
    MatrixNestedImpl() {
      this.builder = new MatrixBuilder(this);
    }
    MatrixBuilder builder;
    public N and() {
      return (N) PipelineTaskFluentImpl.this.withMatrix(builder.build());
    }
    public N endMatrix() {
      return and();
    }
    
  }
  class ParamsNestedImpl<N> extends ParamFluentImpl<PipelineTaskFluentImpl.ParamsNested<N>> implements PipelineTaskFluentImpl.ParamsNested<N>,Nested<N>{
    ParamsNestedImpl(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamsNestedImpl() {
      this.index = -1;
      this.builder = new ParamBuilder(this);
    }
    ParamBuilder builder;
    int index;
    public N and() {
      return (N) PipelineTaskFluentImpl.this.setToParams(index,builder.build());
    }
    public N endParam() {
      return and();
    }
    
  }
  class TaskRefNestedImpl<N> extends TaskRefFluentImpl<PipelineTaskFluentImpl.TaskRefNested<N>> implements PipelineTaskFluentImpl.TaskRefNested<N>,Nested<N>{
    TaskRefNestedImpl(TaskRef item) {
      this.builder = new TaskRefBuilder(this, item);
    }
    TaskRefNestedImpl() {
      this.builder = new TaskRefBuilder(this);
    }
    TaskRefBuilder builder;
    public N and() {
      return (N) PipelineTaskFluentImpl.this.withTaskRef(builder.build());
    }
    public N endTaskRef() {
      return and();
    }
    
  }
  class TaskSpecNestedImpl<N> extends EmbeddedTaskFluentImpl<PipelineTaskFluentImpl.TaskSpecNested<N>> implements PipelineTaskFluentImpl.TaskSpecNested<N>,Nested<N>{
    TaskSpecNestedImpl(EmbeddedTask item) {
      this.builder = new EmbeddedTaskBuilder(this, item);
    }
    TaskSpecNestedImpl() {
      this.builder = new EmbeddedTaskBuilder(this);
    }
    EmbeddedTaskBuilder builder;
    public N and() {
      return (N) PipelineTaskFluentImpl.this.withTaskSpec(builder.build());
    }
    public N endTaskSpec() {
      return and();
    }
    
  }
  class WhenNestedImpl<N> extends WhenExpressionFluentImpl<PipelineTaskFluentImpl.WhenNested<N>> implements PipelineTaskFluentImpl.WhenNested<N>,Nested<N>{
    WhenNestedImpl(int index,WhenExpression item) {
      this.index = index;
      this.builder = new WhenExpressionBuilder(this, item);
    }
    WhenNestedImpl() {
      this.index = -1;
      this.builder = new WhenExpressionBuilder(this);
    }
    WhenExpressionBuilder builder;
    int index;
    public N and() {
      return (N) PipelineTaskFluentImpl.this.setToWhen(index,builder.build());
    }
    public N endWhen() {
      return and();
    }
    
  }
  class WorkspacesNestedImpl<N> extends WorkspacePipelineTaskBindingFluentImpl<PipelineTaskFluentImpl.WorkspacesNested<N>> implements PipelineTaskFluentImpl.WorkspacesNested<N>,Nested<N>{
    WorkspacesNestedImpl(int index,WorkspacePipelineTaskBinding item) {
      this.index = index;
      this.builder = new WorkspacePipelineTaskBindingBuilder(this, item);
    }
    WorkspacesNestedImpl() {
      this.index = -1;
      this.builder = new WorkspacePipelineTaskBindingBuilder(this);
    }
    WorkspacePipelineTaskBindingBuilder builder;
    int index;
    public N and() {
      return (N) PipelineTaskFluentImpl.this.setToWorkspaces(index,builder.build());
    }
    public N endWorkspace() {
      return and();
    }
    
  }
  
}