package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineTaskRunTemplateBuilder extends PipelineTaskRunTemplateFluentImpl<PipelineTaskRunTemplateBuilder> implements VisitableBuilder<PipelineTaskRunTemplate,PipelineTaskRunTemplateBuilder>{
  public PipelineTaskRunTemplateBuilder() {
    this(false);
  }
  public PipelineTaskRunTemplateBuilder(Boolean validationEnabled) {
    this(new PipelineTaskRunTemplate(), validationEnabled);
  }
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineTaskRunTemplate(), validationEnabled);
  }
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplateFluent<?> fluent,PipelineTaskRunTemplate instance) {
    this(fluent, instance, false);
  }
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplateFluent<?> fluent,PipelineTaskRunTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPodTemplate(instance.getPodTemplate());
      fluent.withServiceAccountName(instance.getServiceAccountName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplate instance) {
    this(instance,false);
  }
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPodTemplate(instance.getPodTemplate());
      this.withServiceAccountName(instance.getServiceAccountName());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineTaskRunTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineTaskRunTemplate build() {
    PipelineTaskRunTemplate buildable = new PipelineTaskRunTemplate(fluent.getPodTemplate(),fluent.getServiceAccountName());
    return buildable;
  }
  
}