package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineWorkspaceDeclarationBuilder extends PipelineWorkspaceDeclarationFluentImpl<PipelineWorkspaceDeclarationBuilder> implements VisitableBuilder<PipelineWorkspaceDeclaration,PipelineWorkspaceDeclarationBuilder>{
  public PipelineWorkspaceDeclarationBuilder() {
    this(false);
  }
  public PipelineWorkspaceDeclarationBuilder(Boolean validationEnabled) {
    this(new PipelineWorkspaceDeclaration(), validationEnabled);
  }
  public PipelineWorkspaceDeclarationBuilder(PipelineWorkspaceDeclarationFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineWorkspaceDeclarationBuilder(PipelineWorkspaceDeclarationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineWorkspaceDeclaration(), validationEnabled);
  }
  public PipelineWorkspaceDeclarationBuilder(PipelineWorkspaceDeclarationFluent<?> fluent,PipelineWorkspaceDeclaration instance) {
    this(fluent, instance, false);
  }
  public PipelineWorkspaceDeclarationBuilder(PipelineWorkspaceDeclarationFluent<?> fluent,PipelineWorkspaceDeclaration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineWorkspaceDeclarationBuilder(PipelineWorkspaceDeclaration instance) {
    this(instance,false);
  }
  public PipelineWorkspaceDeclarationBuilder(PipelineWorkspaceDeclaration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineWorkspaceDeclarationFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineWorkspaceDeclaration build() {
    PipelineWorkspaceDeclaration buildable = new PipelineWorkspaceDeclaration(fluent.getDescription(),fluent.getName(),fluent.getOptional());
    return buildable;
  }
  
}