package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PropertySpecBuilder extends PropertySpecFluentImpl<PropertySpecBuilder> implements VisitableBuilder<PropertySpec,PropertySpecBuilder>{
  public PropertySpecBuilder() {
    this(false);
  }
  public PropertySpecBuilder(Boolean validationEnabled) {
    this(new PropertySpec(), validationEnabled);
  }
  public PropertySpecBuilder(PropertySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PropertySpecBuilder(PropertySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PropertySpec(), validationEnabled);
  }
  public PropertySpecBuilder(PropertySpecFluent<?> fluent,PropertySpec instance) {
    this(fluent, instance, false);
  }
  public PropertySpecBuilder(PropertySpecFluent<?> fluent,PropertySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PropertySpecBuilder(PropertySpec instance) {
    this(instance,false);
  }
  public PropertySpecBuilder(PropertySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  PropertySpecFluent<?> fluent;
  Boolean validationEnabled;
  public PropertySpec build() {
    PropertySpec buildable = new PropertySpec(fluent.getType());
    return buildable;
  }
  
}