package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RefSourceBuilder extends RefSourceFluentImpl<RefSourceBuilder> implements VisitableBuilder<RefSource,RefSourceBuilder>{
  public RefSourceBuilder() {
    this(false);
  }
  public RefSourceBuilder(Boolean validationEnabled) {
    this(new RefSource(), validationEnabled);
  }
  public RefSourceBuilder(RefSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public RefSourceBuilder(RefSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RefSource(), validationEnabled);
  }
  public RefSourceBuilder(RefSourceFluent<?> fluent,RefSource instance) {
    this(fluent, instance, false);
  }
  public RefSourceBuilder(RefSourceFluent<?> fluent,RefSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDigest(instance.getDigest());
      fluent.withEntryPoint(instance.getEntryPoint());
      fluent.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RefSourceBuilder(RefSource instance) {
    this(instance,false);
  }
  public RefSourceBuilder(RefSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDigest(instance.getDigest());
      this.withEntryPoint(instance.getEntryPoint());
      this.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  RefSourceFluent<?> fluent;
  Boolean validationEnabled;
  public RefSource build() {
    RefSource buildable = new RefSource(fluent.getDigest(),fluent.getEntryPoint(),fluent.getUri());
    return buildable;
  }
  
}