package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SidecarStateFluentImpl<A extends SidecarStateFluent<A>> extends BaseFluent<A> implements SidecarStateFluent<A>{
  public SidecarStateFluentImpl() {
  }
  public SidecarStateFluentImpl(SidecarState instance) {
    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withImageID(instance.getImageID());
      this.withName(instance.getName());
      this.withRunning(instance.getRunning());
      this.withTerminated(instance.getTerminated());
      this.withWaiting(instance.getWaiting());
    }
  }
  private String container;
  private String imageID;
  private String name;
  private ContainerStateRunning running;
  private ContainerStateTerminated terminated;
  private ContainerStateWaiting waiting;
  public String getContainer() {
    return this.container;
  }
  public A withContainer(String container) {
    this.container=container; return (A) this;
  }
  public Boolean hasContainer() {
    return this.container != null;
  }
  public String getImageID() {
    return this.imageID;
  }
  public A withImageID(String imageID) {
    this.imageID=imageID; return (A) this;
  }
  public Boolean hasImageID() {
    return this.imageID != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public ContainerStateRunning getRunning() {
    return this.running;
  }
  public A withRunning(ContainerStateRunning running) {
    this.running=running; return (A) this;
  }
  public Boolean hasRunning() {
    return this.running != null;
  }
  public A withNewRunning(String startedAt) {
    return (A)withRunning(new ContainerStateRunning(startedAt));
  }
  public ContainerStateTerminated getTerminated() {
    return this.terminated;
  }
  public A withTerminated(ContainerStateTerminated terminated) {
    this.terminated=terminated; return (A) this;
  }
  public Boolean hasTerminated() {
    return this.terminated != null;
  }
  public ContainerStateWaiting getWaiting() {
    return this.waiting;
  }
  public A withWaiting(ContainerStateWaiting waiting) {
    this.waiting=waiting; return (A) this;
  }
  public Boolean hasWaiting() {
    return this.waiting != null;
  }
  public A withNewWaiting(String message,String reason) {
    return (A)withWaiting(new ContainerStateWaiting(message, reason));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SidecarStateFluentImpl that = (SidecarStateFluentImpl) o;
    if (!java.util.Objects.equals(container, that.container)) return false;

    if (!java.util.Objects.equals(imageID, that.imageID)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(running, that.running)) return false;

    if (!java.util.Objects.equals(terminated, that.terminated)) return false;

    if (!java.util.Objects.equals(waiting, that.waiting)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(container,  imageID,  name,  running,  terminated,  waiting,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (imageID != null) { sb.append("imageID:"); sb.append(imageID + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (terminated != null) { sb.append("terminated:"); sb.append(terminated + ","); }
    if (waiting != null) { sb.append("waiting:"); sb.append(waiting); }
    sb.append("}");
    return sb.toString();
  }
  
}