package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepBuilder extends StepFluentImpl<StepBuilder> implements VisitableBuilder<Step,StepBuilder>{
  public StepBuilder() {
    this(false);
  }
  public StepBuilder(Boolean validationEnabled) {
    this(new Step(), validationEnabled);
  }
  public StepBuilder(StepFluent<?> fluent) {
    this(fluent, false);
  }
  public StepBuilder(StepFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Step(), validationEnabled);
  }
  public StepBuilder(StepFluent<?> fluent,Step instance) {
    this(fluent, instance, false);
  }
  public StepBuilder(StepFluent<?> fluent,Step instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withComputeResources(instance.getComputeResources());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withImage(instance.getImage());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withName(instance.getName());
      fluent.withOnError(instance.getOnError());
      fluent.withScript(instance.getScript());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withStderrConfig(instance.getStderrConfig());
      fluent.withStdoutConfig(instance.getStdoutConfig());
      fluent.withTimeout(instance.getTimeout());
      fluent.withVolumeDevices(instance.getVolumeDevices());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withWorkingDir(instance.getWorkingDir());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StepBuilder(Step instance) {
    this(instance,false);
  }
  public StepBuilder(Step instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withComputeResources(instance.getComputeResources());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withName(instance.getName());
      this.withOnError(instance.getOnError());
      this.withScript(instance.getScript());
      this.withSecurityContext(instance.getSecurityContext());
      this.withStderrConfig(instance.getStderrConfig());
      this.withStdoutConfig(instance.getStdoutConfig());
      this.withTimeout(instance.getTimeout());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  StepFluent<?> fluent;
  Boolean validationEnabled;
  public Step build() {
    Step buildable = new Step(fluent.getArgs(),fluent.getCommand(),fluent.getComputeResources(),fluent.getEnv(),fluent.getEnvFrom(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.getName(),fluent.getOnError(),fluent.getScript(),fluent.getSecurityContext(),fluent.getStderrConfig(),fluent.getStdoutConfig(),fluent.getTimeout(),fluent.getVolumeDevices(),fluent.getVolumeMounts(),fluent.getWorkingDir(),fluent.getWorkspaces());
    return buildable;
  }
  
}