package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepStateBuilder extends StepStateFluentImpl<StepStateBuilder> implements VisitableBuilder<StepState,StepStateBuilder>{
  public StepStateBuilder() {
    this(false);
  }
  public StepStateBuilder(Boolean validationEnabled) {
    this(new StepState(), validationEnabled);
  }
  public StepStateBuilder(StepStateFluent<?> fluent) {
    this(fluent, false);
  }
  public StepStateBuilder(StepStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StepState(), validationEnabled);
  }
  public StepStateBuilder(StepStateFluent<?> fluent,StepState instance) {
    this(fluent, instance, false);
  }
  public StepStateBuilder(StepStateFluent<?> fluent,StepState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainer(instance.getContainer());
      fluent.withImageID(instance.getImageID());
      fluent.withName(instance.getName());
      fluent.withRunning(instance.getRunning());
      fluent.withTerminated(instance.getTerminated());
      fluent.withWaiting(instance.getWaiting());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StepStateBuilder(StepState instance) {
    this(instance,false);
  }
  public StepStateBuilder(StepState instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withImageID(instance.getImageID());
      this.withName(instance.getName());
      this.withRunning(instance.getRunning());
      this.withTerminated(instance.getTerminated());
      this.withWaiting(instance.getWaiting());
    }
    this.validationEnabled = validationEnabled; 
  }
  StepStateFluent<?> fluent;
  Boolean validationEnabled;
  public StepState build() {
    StepState buildable = new StepState(fluent.getContainer(),fluent.getImageID(),fluent.getName(),fluent.getRunning(),fluent.getTerminated(),fluent.getWaiting());
    return buildable;
  }
  
}