package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.VolumeDevice;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StepTemplateFluentImpl<A extends StepTemplateFluent<A>> extends BaseFluent<A> implements StepTemplateFluent<A>{
  public StepTemplateFluentImpl() {
  }
  public StepTemplateFluentImpl(StepTemplate instance) {
    if (instance != null) {
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withComputeResources(instance.getComputeResources());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withSecurityContext(instance.getSecurityContext());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
    }
  }
  private List<String> args = new ArrayList<String>();
  private List<String> command = new ArrayList<String>();
  private ResourceRequirementsBuilder computeResources;
  private ArrayList<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
  private List<EnvFromSource> envFrom = new ArrayList<EnvFromSource>();
  private String image;
  private String imagePullPolicy;
  private SecurityContext securityContext;
  private List<VolumeDevice> volumeDevices = new ArrayList<VolumeDevice>();
  private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList<VolumeMountBuilder>();
  private String workingDir;
  public A addToArgs(int index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.add(index, item);
    return (A)this;
  }
  public A setToArgs(int index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.set(index, item); return (A)this;
  }
  public A addToArgs(java.lang.String... items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  public A addAllToArgs(Collection<String> items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  public A removeFromArgs(java.lang.String... items) {
    for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public A removeAllFromArgs(Collection<String> items) {
    for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public List<String> getArgs() {
    return this.args;
  }
  public String getArg(int index) {
    return this.args.get(index);
  }
  public String getFirstArg() {
    return this.args.get(0);
  }
  public String getLastArg() {
    return this.args.get(args.size() - 1);
  }
  public String getMatchingArg(Predicate<String> predicate) {
    for (String item: args) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingArg(Predicate<String> predicate) {
    for (String item: args) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArgs(List<String> args) {
    if (args != null) {this.args = new ArrayList(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
  }
  public A withArgs(java.lang.String... args) {
    if (this.args != null) {this.args.clear(); _visitables.remove("args"); }
    if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
  }
  public Boolean hasArgs() {
    return args != null && !args.isEmpty();
  }
  public A addToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  public A setToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  public A removeFromCommand(java.lang.String... items) {
    for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public A removeAllFromCommand(Collection<String> items) {
    for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public List<String> getCommand() {
    return this.command;
  }
  public String getCommand(int index) {
    return this.command.get(index);
  }
  public String getFirstCommand() {
    return this.command.get(0);
  }
  public String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  public String getMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCommand(List<String> command) {
    if (command != null) {this.command = new ArrayList(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
  }
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {this.command.clear(); _visitables.remove("command"); }
    if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
  }
  public Boolean hasCommand() {
    return command != null && !command.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildComputeResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getComputeResources() {
    return this.computeResources!=null ?this.computeResources.build():null;
  }
  public ResourceRequirements buildComputeResources() {
    return this.computeResources!=null ?this.computeResources.build():null;
  }
  public A withComputeResources(ResourceRequirements computeResources) {
    _visitables.get("computeResources").remove(this.computeResources);
    if (computeResources!=null){ this.computeResources= new ResourceRequirementsBuilder(computeResources); _visitables.get("computeResources").add(this.computeResources);} else { this.computeResources = null; _visitables.get("computeResources").remove(this.computeResources); } return (A) this;
  }
  public Boolean hasComputeResources() {
    return this.computeResources != null;
  }
  public StepTemplateFluentImpl.ComputeResourcesNested<A> withNewComputeResources() {
    return new StepTemplateFluentImpl.ComputeResourcesNestedImpl();
  }
  public StepTemplateFluentImpl.ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
    return new StepTemplateFluentImpl.ComputeResourcesNestedImpl(item);
  }
  public StepTemplateFluentImpl.ComputeResourcesNested<A> editComputeResources() {
    return withNewComputeResourcesLike(getComputeResources());
  }
  public StepTemplateFluentImpl.ComputeResourcesNested<A> editOrNewComputeResources() {
    return withNewComputeResourcesLike(getComputeResources() != null ? getComputeResources(): new ResourceRequirementsBuilder().build());
  }
  public StepTemplateFluentImpl.ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
    return withNewComputeResourcesLike(getComputeResources() != null ? getComputeResources(): item);
  }
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<EnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EnvVar> getEnv() {
    return env != null ? build(env) : null;
  }
  public List<EnvVar> buildEnv() {
    return env != null ? build(env) : null;
  }
  public EnvVar buildEnv(int index) {
    return this.env.get(index).build();
  }
  public EnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  public EnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    for (EnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    for (EnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (this.env != null) { _visitables.get("env").clear();}
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public StepTemplateFluentImpl.EnvNested<A> addNewEnv() {
    return new StepTemplateFluentImpl.EnvNestedImpl();
  }
  public StepTemplateFluentImpl.EnvNested<A> addNewEnvLike(EnvVar item) {
    return new StepTemplateFluentImpl.EnvNestedImpl(-1, item);
  }
  public StepTemplateFluentImpl.EnvNested<A> setNewEnvLike(int index,EnvVar item) {
    return new StepTemplateFluentImpl.EnvNestedImpl(index, item);
  }
  public StepTemplateFluentImpl.EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public StepTemplateFluentImpl.EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public StepTemplateFluentImpl.EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public StepTemplateFluentImpl.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public A addToEnvFrom(int index,EnvFromSource item) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    this.envFrom.add(index, item);
    return (A)this;
  }
  public A setToEnvFrom(int index,EnvFromSource item) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    this.envFrom.set(index, item); return (A)this;
  }
  public A addToEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
  }
  public A addAllToEnvFrom(Collection<EnvFromSource> items) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
  }
  public A removeFromEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
    for (EnvFromSource item : items) {if (this.envFrom!= null){ this.envFrom.remove(item);}} return (A)this;
  }
  public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
    for (EnvFromSource item : items) {if (this.envFrom!= null){ this.envFrom.remove(item);}} return (A)this;
  }
  public List<EnvFromSource> getEnvFrom() {
    return this.envFrom;
  }
  public EnvFromSource getEnvFrom(int index) {
    return this.envFrom.get(index);
  }
  public EnvFromSource getFirstEnvFrom() {
    return this.envFrom.get(0);
  }
  public EnvFromSource getLastEnvFrom() {
    return this.envFrom.get(envFrom.size() - 1);
  }
  public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
    for (EnvFromSource item: envFrom) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
    for (EnvFromSource item: envFrom) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnvFrom(List<EnvFromSource> envFrom) {
    if (envFrom != null) {this.envFrom = new ArrayList(); for (EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
  }
  public A withEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... envFrom) {
    if (this.envFrom != null) {this.envFrom.clear(); _visitables.remove("envFrom"); }
    if (envFrom != null) {for (EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
  }
  public Boolean hasEnvFrom() {
    return envFrom != null && !envFrom.isEmpty();
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  public A withImagePullPolicy(String imagePullPolicy) {
    this.imagePullPolicy=imagePullPolicy; return (A) this;
  }
  public Boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  public SecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(SecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public A addToVolumeDevices(int index,VolumeDevice item) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDevice>();}
    this.volumeDevices.add(index, item);
    return (A)this;
  }
  public A setToVolumeDevices(int index,VolumeDevice item) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDevice>();}
    this.volumeDevices.set(index, item); return (A)this;
  }
  public A addToVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDevice>();}
    for (VolumeDevice item : items) {this.volumeDevices.add(item);} return (A)this;
  }
  public A addAllToVolumeDevices(Collection<VolumeDevice> items) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDevice>();}
    for (VolumeDevice item : items) {this.volumeDevices.add(item);} return (A)this;
  }
  public A removeFromVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items) {
    for (VolumeDevice item : items) {if (this.volumeDevices!= null){ this.volumeDevices.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumeDevices(Collection<VolumeDevice> items) {
    for (VolumeDevice item : items) {if (this.volumeDevices!= null){ this.volumeDevices.remove(item);}} return (A)this;
  }
  public List<VolumeDevice> getVolumeDevices() {
    return this.volumeDevices;
  }
  public VolumeDevice getVolumeDevice(int index) {
    return this.volumeDevices.get(index);
  }
  public VolumeDevice getFirstVolumeDevice() {
    return this.volumeDevices.get(0);
  }
  public VolumeDevice getLastVolumeDevice() {
    return this.volumeDevices.get(volumeDevices.size() - 1);
  }
  public VolumeDevice getMatchingVolumeDevice(Predicate<VolumeDevice> predicate) {
    for (VolumeDevice item: volumeDevices) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolumeDevice(Predicate<VolumeDevice> predicate) {
    for (VolumeDevice item: volumeDevices) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeDevices(List<VolumeDevice> volumeDevices) {
    if (volumeDevices != null) {this.volumeDevices = new ArrayList(); for (VolumeDevice item : volumeDevices){this.addToVolumeDevices(item);}} else { this.volumeDevices = null;} return (A) this;
  }
  public A withVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... volumeDevices) {
    if (this.volumeDevices != null) {this.volumeDevices.clear(); _visitables.remove("volumeDevices"); }
    if (volumeDevices != null) {for (VolumeDevice item :volumeDevices){ this.addToVolumeDevices(item);}} return (A) this;
  }
  public Boolean hasVolumeDevices() {
    return volumeDevices != null && !volumeDevices.isEmpty();
  }
  public A addNewVolumeDevice(String devicePath,String name) {
    return (A)addToVolumeDevices(new VolumeDevice(devicePath, name));
  }
  public A addToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) { _visitables.get("volumeMounts").add(builder); volumeMounts.add(builder); } else { _visitables.get("volumeMounts").add(index, builder); volumeMounts.add(index, builder);}
    return (A)this;
  }
  public A setToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) { _visitables.get("volumeMounts").add(builder); volumeMounts.add(builder); } else { _visitables.get("volumeMounts").set(index, builder); volumeMounts.set(index, builder);}
    return (A)this;
  }
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
    if (volumeMounts == null) return (A) this;
    final Iterator<VolumeMountBuilder> each = volumeMounts.iterator();
    final List visitables = _visitables.get("volumeMounts");
    while (each.hasNext()) {
      VolumeMountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumeMounts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<VolumeMount> getVolumeMounts() {
    return volumeMounts != null ? build(volumeMounts) : null;
  }
  public List<VolumeMount> buildVolumeMounts() {
    return volumeMounts != null ? build(volumeMounts) : null;
  }
  public VolumeMount buildVolumeMount(int index) {
    return this.volumeMounts.get(index).build();
  }
  public VolumeMount buildFirstVolumeMount() {
    return this.volumeMounts.get(0).build();
  }
  public VolumeMount buildLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1).build();
  }
  public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (this.volumeMounts != null) { _visitables.get("volumeMounts").clear();}
    if (volumeMounts != null) {this.volumeMounts = new ArrayList(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
  }
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear(); _visitables.remove("volumeMounts"); }
    if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  public Boolean hasVolumeMounts() {
    return volumeMounts != null && !volumeMounts.isEmpty();
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> addNewVolumeMount() {
    return new StepTemplateFluentImpl.VolumeMountsNestedImpl();
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
    return new StepTemplateFluentImpl.VolumeMountsNestedImpl(-1, item);
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item) {
    return new StepTemplateFluentImpl.VolumeMountsNestedImpl(index, item);
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> editVolumeMount(int index) {
    if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> editFirstVolumeMount() {
    if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
    return setNewVolumeMountLike(0, buildVolumeMount(0));
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> editLastVolumeMount() {
    int index = volumeMounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  public StepTemplateFluentImpl.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeMounts.size();i++) { 
    if (predicate.test(volumeMounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  public String getWorkingDir() {
    return this.workingDir;
  }
  public A withWorkingDir(String workingDir) {
    this.workingDir=workingDir; return (A) this;
  }
  public Boolean hasWorkingDir() {
    return this.workingDir != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StepTemplateFluentImpl that = (StepTemplateFluentImpl) o;
    if (!java.util.Objects.equals(args, that.args)) return false;

    if (!java.util.Objects.equals(command, that.command)) return false;

    if (!java.util.Objects.equals(computeResources, that.computeResources)) return false;

    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(envFrom, that.envFrom)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;

    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;

    if (!java.util.Objects.equals(volumeDevices, that.volumeDevices)) return false;

    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;

    if (!java.util.Objects.equals(workingDir, that.workingDir)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(args,  command,  computeResources,  env,  envFrom,  image,  imagePullPolicy,  securityContext,  volumeDevices,  volumeMounts,  workingDir,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (args != null && !args.isEmpty()) { sb.append("args:"); sb.append(args + ","); }
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (computeResources != null) { sb.append("computeResources:"); sb.append(computeResources + ","); }
    if (env != null) { sb.append("env:"); sb.append(env + ","); }
    if (envFrom != null && !envFrom.isEmpty()) { sb.append("envFrom:"); sb.append(envFrom + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (volumeDevices != null && !volumeDevices.isEmpty()) { sb.append("volumeDevices:"); sb.append(volumeDevices + ","); }
    if (volumeMounts != null) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (workingDir != null) { sb.append("workingDir:"); sb.append(workingDir); }
    sb.append("}");
    return sb.toString();
  }
  class ComputeResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<StepTemplateFluentImpl.ComputeResourcesNested<N>> implements StepTemplateFluentImpl.ComputeResourcesNested<N>,Nested<N>{
    ComputeResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ComputeResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) StepTemplateFluentImpl.this.withComputeResources(builder.build());
    }
    public N endComputeResources() {
      return and();
    }
    
  }
  class EnvNestedImpl<N> extends EnvVarFluentImpl<StepTemplateFluentImpl.EnvNested<N>> implements StepTemplateFluentImpl.EnvNested<N>,Nested<N>{
    EnvNestedImpl(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvNestedImpl() {
      this.index = -1;
      this.builder = new EnvVarBuilder(this);
    }
    EnvVarBuilder builder;
    int index;
    public N and() {
      return (N) StepTemplateFluentImpl.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  class VolumeMountsNestedImpl<N> extends VolumeMountFluentImpl<StepTemplateFluentImpl.VolumeMountsNested<N>> implements StepTemplateFluentImpl.VolumeMountsNested<N>,Nested<N>{
    VolumeMountsNestedImpl(int index,VolumeMount item) {
      this.index = index;
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountsNestedImpl() {
      this.index = -1;
      this.builder = new VolumeMountBuilder(this);
    }
    VolumeMountBuilder builder;
    int index;
    public N and() {
      return (N) StepTemplateFluentImpl.this.setToVolumeMounts(index,builder.build());
    }
    public N endVolumeMount() {
      return and();
    }
    
  }
  
}