package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskBuilder extends TaskFluentImpl<TaskBuilder> implements VisitableBuilder<Task,TaskBuilder>{
  public TaskBuilder() {
    this(false);
  }
  public TaskBuilder(Boolean validationEnabled) {
    this(new Task(), validationEnabled);
  }
  public TaskBuilder(TaskFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskBuilder(TaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Task(), validationEnabled);
  }
  public TaskBuilder(TaskFluent<?> fluent,Task instance) {
    this(fluent, instance, false);
  }
  public TaskBuilder(TaskFluent<?> fluent,Task instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskBuilder(Task instance) {
    this(instance,false);
  }
  public TaskBuilder(Task instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskFluent<?> fluent;
  Boolean validationEnabled;
  public Task build() {
    Task buildable = new Task(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  
}