package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskListBuilder extends TaskListFluentImpl<TaskListBuilder> implements VisitableBuilder<TaskList,TaskListBuilder>{
  public TaskListBuilder() {
    this(false);
  }
  public TaskListBuilder(Boolean validationEnabled) {
    this(new TaskList(), validationEnabled);
  }
  public TaskListBuilder(TaskListFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskListBuilder(TaskListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskList(), validationEnabled);
  }
  public TaskListBuilder(TaskListFluent<?> fluent,TaskList instance) {
    this(fluent, instance, false);
  }
  public TaskListBuilder(TaskListFluent<?> fluent,TaskList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskListBuilder(TaskList instance) {
    this(instance,false);
  }
  public TaskListBuilder(TaskList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskListFluent<?> fluent;
  Boolean validationEnabled;
  public TaskList build() {
    TaskList buildable = new TaskList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}