package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TaskRefFluentImpl<A extends TaskRefFluent<A>> extends BaseFluent<A> implements TaskRefFluent<A>{
  public TaskRefFluentImpl() {
  }
  public TaskRefFluentImpl(TaskRef instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withParams(instance.getParams());
      this.withResolver(instance.getResolver());
    }
  }
  private String apiVersion;
  private String kind;
  private String name;
  private ArrayList<ParamBuilder> params = new ArrayList<ParamBuilder>();
  private String resolver;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  public A setToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  public A addToParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A addAllToParams(Collection<Param> items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A removeFromParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeAllFromParams(Collection<Param> items) {
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Param> getParams() {
    return params != null ? build(params) : null;
  }
  public List<Param> buildParams() {
    return params != null ? build(params) : null;
  }
  public Param buildParam(int index) {
    return this.params.get(index).build();
  }
  public Param buildFirstParam() {
    return this.params.get(0).build();
  }
  public Param buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
    for (ParamBuilder item: params) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
    for (ParamBuilder item: params) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParams(List<Param> params) {
    if (this.params != null) { _visitables.get("params").clear();}
    if (params != null) {this.params = new ArrayList(); for (Param item : params){this.addToParams(item);}} else { this.params = null;} return (A) this;
  }
  public A withParams(io.fabric8.tekton.pipeline.v1.Param... params) {
    if (this.params != null) {this.params.clear(); _visitables.remove("params"); }
    if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
  }
  public Boolean hasParams() {
    return params != null && !params.isEmpty();
  }
  public TaskRefFluentImpl.ParamsNested<A> addNewParam() {
    return new TaskRefFluentImpl.ParamsNestedImpl();
  }
  public TaskRefFluentImpl.ParamsNested<A> addNewParamLike(Param item) {
    return new TaskRefFluentImpl.ParamsNestedImpl(-1, item);
  }
  public TaskRefFluentImpl.ParamsNested<A> setNewParamLike(int index,Param item) {
    return new TaskRefFluentImpl.ParamsNestedImpl(index, item);
  }
  public TaskRefFluentImpl.ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  public TaskRefFluentImpl.ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  public TaskRefFluentImpl.ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  public TaskRefFluentImpl.ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  public String getResolver() {
    return this.resolver;
  }
  public A withResolver(String resolver) {
    this.resolver=resolver; return (A) this;
  }
  public Boolean hasResolver() {
    return this.resolver != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskRefFluentImpl that = (TaskRefFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(params, that.params)) return false;

    if (!java.util.Objects.equals(resolver, that.resolver)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  name,  params,  resolver,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (params != null) { sb.append("params:"); sb.append(params + ","); }
    if (resolver != null) { sb.append("resolver:"); sb.append(resolver); }
    sb.append("}");
    return sb.toString();
  }
  class ParamsNestedImpl<N> extends ParamFluentImpl<TaskRefFluentImpl.ParamsNested<N>> implements TaskRefFluentImpl.ParamsNested<N>,Nested<N>{
    ParamsNestedImpl(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamsNestedImpl() {
      this.index = -1;
      this.builder = new ParamBuilder(this);
    }
    ParamBuilder builder;
    int index;
    public N and() {
      return (N) TaskRefFluentImpl.this.setToParams(index,builder.build());
    }
    public N endParam() {
      return and();
    }
    
  }
  
}