package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunBuilder extends TaskRunFluentImpl<TaskRunBuilder> implements VisitableBuilder<TaskRun,TaskRunBuilder>{
  public TaskRunBuilder() {
    this(false);
  }
  public TaskRunBuilder(Boolean validationEnabled) {
    this(new TaskRun(), validationEnabled);
  }
  public TaskRunBuilder(TaskRunFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunBuilder(TaskRunFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRun(), validationEnabled);
  }
  public TaskRunBuilder(TaskRunFluent<?> fluent,TaskRun instance) {
    this(fluent, instance, false);
  }
  public TaskRunBuilder(TaskRunFluent<?> fluent,TaskRun instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunBuilder(TaskRun instance) {
    this(instance,false);
  }
  public TaskRunBuilder(TaskRun instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRun build() {
    TaskRun buildable = new TaskRun(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}