package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface TaskRunStatusFluent<A extends TaskRunStatusFluent<A>> extends Fluent<A>{
  public A addToAnnotations(String key,String value);
  public A addToAnnotations(Map<String,String> map);
  public A removeFromAnnotations(String key);
  public A removeFromAnnotations(Map<String,String> map);
  public Map<String,String> getAnnotations();
  public <K,V>A withAnnotations(Map<String,String> annotations);
  public Boolean hasAnnotations();
  public String getCompletionTime();
  public A withCompletionTime(String completionTime);
  public Boolean hasCompletionTime();
  public A addToConditions(int index,Condition item);
  public A setToConditions(int index,Condition item);
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public List<Condition> getConditions();
  public Condition getCondition(int index);
  public Condition getFirstCondition();
  public Condition getLastCondition();
  public Condition getMatchingCondition(Predicate<Condition> predicate);
  public Boolean hasMatchingCondition(Predicate<Condition> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions);
  public Boolean hasConditions();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public String getPodName();
  public A withPodName(String podName);
  public Boolean hasPodName();
  
  /**
   * This method has been deprecated, please use method buildProvenance instead.
   * @return The buildable object.
   */
  @Deprecated
  public Provenance getProvenance();
  public Provenance buildProvenance();
  public A withProvenance(Provenance provenance);
  public Boolean hasProvenance();
  public TaskRunStatusFluent.ProvenanceNested<A> withNewProvenance();
  public TaskRunStatusFluent.ProvenanceNested<A> withNewProvenanceLike(Provenance item);
  public TaskRunStatusFluent.ProvenanceNested<A> editProvenance();
  public TaskRunStatusFluent.ProvenanceNested<A> editOrNewProvenance();
  public TaskRunStatusFluent.ProvenanceNested<A> editOrNewProvenanceLike(Provenance item);
  public A addToResults(int index,TaskRunResult item);
  public A setToResults(int index,TaskRunResult item);
  public A addToResults(io.fabric8.tekton.pipeline.v1.TaskRunResult... items);
  public A addAllToResults(Collection<TaskRunResult> items);
  public A removeFromResults(io.fabric8.tekton.pipeline.v1.TaskRunResult... items);
  public A removeAllFromResults(Collection<TaskRunResult> items);
  public A removeMatchingFromResults(Predicate<TaskRunResultBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildResults instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunResult> getResults();
  public List<TaskRunResult> buildResults();
  public TaskRunResult buildResult(int index);
  public TaskRunResult buildFirstResult();
  public TaskRunResult buildLastResult();
  public TaskRunResult buildMatchingResult(Predicate<TaskRunResultBuilder> predicate);
  public Boolean hasMatchingResult(Predicate<TaskRunResultBuilder> predicate);
  public A withResults(List<TaskRunResult> results);
  public A withResults(io.fabric8.tekton.pipeline.v1.TaskRunResult... results);
  public Boolean hasResults();
  public TaskRunStatusFluent.ResultsNested<A> addNewResult();
  public TaskRunStatusFluent.ResultsNested<A> addNewResultLike(TaskRunResult item);
  public TaskRunStatusFluent.ResultsNested<A> setNewResultLike(int index,TaskRunResult item);
  public TaskRunStatusFluent.ResultsNested<A> editResult(int index);
  public TaskRunStatusFluent.ResultsNested<A> editFirstResult();
  public TaskRunStatusFluent.ResultsNested<A> editLastResult();
  public TaskRunStatusFluent.ResultsNested<A> editMatchingResult(Predicate<TaskRunResultBuilder> predicate);
  public A addToRetriesStatus(int index,TaskRunStatus item);
  public A setToRetriesStatus(int index,TaskRunStatus item);
  public A addToRetriesStatus(io.fabric8.tekton.pipeline.v1.TaskRunStatus... items);
  public A addAllToRetriesStatus(Collection<TaskRunStatus> items);
  public A removeFromRetriesStatus(io.fabric8.tekton.pipeline.v1.TaskRunStatus... items);
  public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items);
  public A removeMatchingFromRetriesStatus(Predicate<TaskRunStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRetriesStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunStatus> getRetriesStatus();
  public List<TaskRunStatus> buildRetriesStatus();
  public TaskRunStatus buildRetriesStatus(int index);
  public TaskRunStatus buildFirstRetriesStatus();
  public TaskRunStatus buildLastRetriesStatus();
  public TaskRunStatus buildMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate);
  public Boolean hasMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate);
  public A withRetriesStatus(List<TaskRunStatus> retriesStatus);
  public A withRetriesStatus(io.fabric8.tekton.pipeline.v1.TaskRunStatus... retriesStatus);
  public Boolean hasRetriesStatus();
  public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatus();
  public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item);
  public TaskRunStatusFluent.RetriesStatusNested<A> setNewRetriesStatusLike(int index,TaskRunStatus item);
  public TaskRunStatusFluent.RetriesStatusNested<A> editRetriesStatus(int index);
  public TaskRunStatusFluent.RetriesStatusNested<A> editFirstRetriesStatus();
  public TaskRunStatusFluent.RetriesStatusNested<A> editLastRetriesStatus();
  public TaskRunStatusFluent.RetriesStatusNested<A> editMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate);
  public A addToSidecars(int index,SidecarState item);
  public A setToSidecars(int index,SidecarState item);
  public A addToSidecars(io.fabric8.tekton.pipeline.v1.SidecarState... items);
  public A addAllToSidecars(Collection<SidecarState> items);
  public A removeFromSidecars(io.fabric8.tekton.pipeline.v1.SidecarState... items);
  public A removeAllFromSidecars(Collection<SidecarState> items);
  public A removeMatchingFromSidecars(Predicate<SidecarStateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSidecars instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SidecarState> getSidecars();
  public List<SidecarState> buildSidecars();
  public SidecarState buildSidecar(int index);
  public SidecarState buildFirstSidecar();
  public SidecarState buildLastSidecar();
  public SidecarState buildMatchingSidecar(Predicate<SidecarStateBuilder> predicate);
  public Boolean hasMatchingSidecar(Predicate<SidecarStateBuilder> predicate);
  public A withSidecars(List<SidecarState> sidecars);
  public A withSidecars(io.fabric8.tekton.pipeline.v1.SidecarState... sidecars);
  public Boolean hasSidecars();
  public TaskRunStatusFluent.SidecarsNested<A> addNewSidecar();
  public TaskRunStatusFluent.SidecarsNested<A> addNewSidecarLike(SidecarState item);
  public TaskRunStatusFluent.SidecarsNested<A> setNewSidecarLike(int index,SidecarState item);
  public TaskRunStatusFluent.SidecarsNested<A> editSidecar(int index);
  public TaskRunStatusFluent.SidecarsNested<A> editFirstSidecar();
  public TaskRunStatusFluent.SidecarsNested<A> editLastSidecar();
  public TaskRunStatusFluent.SidecarsNested<A> editMatchingSidecar(Predicate<SidecarStateBuilder> predicate);
  public A addToSpanContext(String key,String value);
  public A addToSpanContext(Map<String,String> map);
  public A removeFromSpanContext(String key);
  public A removeFromSpanContext(Map<String,String> map);
  public Map<String,String> getSpanContext();
  public <K,V>A withSpanContext(Map<String,String> spanContext);
  public Boolean hasSpanContext();
  public String getStartTime();
  public A withStartTime(String startTime);
  public Boolean hasStartTime();
  public A addToSteps(int index,StepState item);
  public A setToSteps(int index,StepState item);
  public A addToSteps(io.fabric8.tekton.pipeline.v1.StepState... items);
  public A addAllToSteps(Collection<StepState> items);
  public A removeFromSteps(io.fabric8.tekton.pipeline.v1.StepState... items);
  public A removeAllFromSteps(Collection<StepState> items);
  public A removeMatchingFromSteps(Predicate<StepStateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSteps instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StepState> getSteps();
  public List<StepState> buildSteps();
  public StepState buildStep(int index);
  public StepState buildFirstStep();
  public StepState buildLastStep();
  public StepState buildMatchingStep(Predicate<StepStateBuilder> predicate);
  public Boolean hasMatchingStep(Predicate<StepStateBuilder> predicate);
  public A withSteps(List<StepState> steps);
  public A withSteps(io.fabric8.tekton.pipeline.v1.StepState... steps);
  public Boolean hasSteps();
  public TaskRunStatusFluent.StepsNested<A> addNewStep();
  public TaskRunStatusFluent.StepsNested<A> addNewStepLike(StepState item);
  public TaskRunStatusFluent.StepsNested<A> setNewStepLike(int index,StepState item);
  public TaskRunStatusFluent.StepsNested<A> editStep(int index);
  public TaskRunStatusFluent.StepsNested<A> editFirstStep();
  public TaskRunStatusFluent.StepsNested<A> editLastStep();
  public TaskRunStatusFluent.StepsNested<A> editMatchingStep(Predicate<StepStateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTaskSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TaskSpec getTaskSpec();
  public TaskSpec buildTaskSpec();
  public A withTaskSpec(TaskSpec taskSpec);
  public Boolean hasTaskSpec();
  public TaskRunStatusFluent.TaskSpecNested<A> withNewTaskSpec();
  public TaskRunStatusFluent.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item);
  public TaskRunStatusFluent.TaskSpecNested<A> editTaskSpec();
  public TaskRunStatusFluent.TaskSpecNested<A> editOrNewTaskSpec();
  public TaskRunStatusFluent.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item);
  public interface ProvenanceNested<N> extends Nested<N>,ProvenanceFluent<TaskRunStatusFluent.ProvenanceNested<N>>{
    public N and();
    public N endProvenance();
    
  }
  public interface ResultsNested<N> extends Nested<N>,TaskRunResultFluent<TaskRunStatusFluent.ResultsNested<N>>{
    public N and();
    public N endResult();
    
  }
  public interface RetriesStatusNested<N> extends Nested<N>,TaskRunStatusFluent<TaskRunStatusFluent.RetriesStatusNested<N>>{
    public N and();
    public N endRetriesStatus();
    
  }
  public interface SidecarsNested<N> extends Nested<N>,SidecarStateFluent<TaskRunStatusFluent.SidecarsNested<N>>{
    public N and();
    public N endSidecar();
    
  }
  public interface StepsNested<N> extends Nested<N>,StepStateFluent<TaskRunStatusFluent.StepsNested<N>>{
    public N and();
    public N endStep();
    
  }
  public interface TaskSpecNested<N> extends Nested<N>,TaskSpecFluent<TaskRunStatusFluent.TaskSpecNested<N>>{
    public N and();
    public N endTaskSpec();
    
  }
  
}