package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WhenExpressionBuilder extends WhenExpressionFluentImpl<WhenExpressionBuilder> implements VisitableBuilder<WhenExpression,WhenExpressionBuilder>{
  public WhenExpressionBuilder() {
    this(false);
  }
  public WhenExpressionBuilder(Boolean validationEnabled) {
    this(new WhenExpression(), validationEnabled);
  }
  public WhenExpressionBuilder(WhenExpressionFluent<?> fluent) {
    this(fluent, false);
  }
  public WhenExpressionBuilder(WhenExpressionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WhenExpression(), validationEnabled);
  }
  public WhenExpressionBuilder(WhenExpressionFluent<?> fluent,WhenExpression instance) {
    this(fluent, instance, false);
  }
  public WhenExpressionBuilder(WhenExpressionFluent<?> fluent,WhenExpression instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withInput(instance.getInput());
      fluent.withOperator(instance.getOperator());
      fluent.withValues(instance.getValues());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WhenExpressionBuilder(WhenExpression instance) {
    this(instance,false);
  }
  public WhenExpressionBuilder(WhenExpression instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withInput(instance.getInput());
      this.withOperator(instance.getOperator());
      this.withValues(instance.getValues());
    }
    this.validationEnabled = validationEnabled; 
  }
  WhenExpressionFluent<?> fluent;
  Boolean validationEnabled;
  public WhenExpression build() {
    WhenExpression buildable = new WhenExpression(fluent.getInput(),fluent.getOperator(),fluent.getValues());
    return buildable;
  }
  
}