package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkspaceBindingBuilder extends WorkspaceBindingFluentImpl<WorkspaceBindingBuilder> implements VisitableBuilder<WorkspaceBinding,WorkspaceBindingBuilder>{
  public WorkspaceBindingBuilder() {
    this(false);
  }
  public WorkspaceBindingBuilder(Boolean validationEnabled) {
    this(new WorkspaceBinding(), validationEnabled);
  }
  public WorkspaceBindingBuilder(WorkspaceBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkspaceBindingBuilder(WorkspaceBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkspaceBinding(), validationEnabled);
  }
  public WorkspaceBindingBuilder(WorkspaceBindingFluent<?> fluent,WorkspaceBinding instance) {
    this(fluent, instance, false);
  }
  public WorkspaceBindingBuilder(WorkspaceBindingFluent<?> fluent,WorkspaceBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withCsi(instance.getCsi());
      fluent.withEmptyDir(instance.getEmptyDir());
      fluent.withName(instance.getName());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withProjected(instance.getProjected());
      fluent.withSecret(instance.getSecret());
      fluent.withSubPath(instance.getSubPath());
      fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkspaceBindingBuilder(WorkspaceBinding instance) {
    this(instance,false);
  }
  public WorkspaceBindingBuilder(WorkspaceBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withCsi(instance.getCsi());
      this.withEmptyDir(instance.getEmptyDir());
      this.withName(instance.getName());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withProjected(instance.getProjected());
      this.withSecret(instance.getSecret());
      this.withSubPath(instance.getSubPath());
      this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkspaceBindingFluent<?> fluent;
  Boolean validationEnabled;
  public WorkspaceBinding build() {
    WorkspaceBinding buildable = new WorkspaceBinding(fluent.getConfigMap(),fluent.getCsi(),fluent.getEmptyDir(),fluent.getName(),fluent.getPersistentVolumeClaim(),fluent.getProjected(),fluent.getSecret(),fluent.getSubPath(),fluent.getVolumeClaimTemplate());
    return buildable;
  }
  
}