package io.fabric8.tekton.pipeline.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ProjectedVolumeSource;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WorkspaceBindingFluentImpl<A extends WorkspaceBindingFluent<A>> extends BaseFluent<A> implements WorkspaceBindingFluent<A>{
  public WorkspaceBindingFluentImpl() {
  }
  public WorkspaceBindingFluentImpl(WorkspaceBinding instance) {
    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withCsi(instance.getCsi());
      this.withEmptyDir(instance.getEmptyDir());
      this.withName(instance.getName());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withProjected(instance.getProjected());
      this.withSecret(instance.getSecret());
      this.withSubPath(instance.getSubPath());
      this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }
  }
  private ConfigMapVolumeSource configMap;
  private CSIVolumeSource csi;
  private EmptyDirVolumeSource emptyDir;
  private String name;
  private PersistentVolumeClaimVolumeSource persistentVolumeClaim;
  private ProjectedVolumeSource projected;
  private SecretVolumeSource secret;
  private String subPath;
  private PersistentVolumeClaimBuilder volumeClaimTemplate;
  public ConfigMapVolumeSource getConfigMap() {
    return this.configMap;
  }
  public A withConfigMap(ConfigMapVolumeSource configMap) {
    this.configMap=configMap; return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public CSIVolumeSource getCsi() {
    return this.csi;
  }
  public A withCsi(CSIVolumeSource csi) {
    this.csi=csi; return (A) this;
  }
  public Boolean hasCsi() {
    return this.csi != null;
  }
  public EmptyDirVolumeSource getEmptyDir() {
    return this.emptyDir;
  }
  public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
    this.emptyDir=emptyDir; return (A) this;
  }
  public Boolean hasEmptyDir() {
    return this.emptyDir != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
    return this.persistentVolumeClaim;
  }
  public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    this.persistentVolumeClaim=persistentVolumeClaim; return (A) this;
  }
  public Boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly) {
    return (A)withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  public ProjectedVolumeSource getProjected() {
    return this.projected;
  }
  public A withProjected(ProjectedVolumeSource projected) {
    this.projected=projected; return (A) this;
  }
  public Boolean hasProjected() {
    return this.projected != null;
  }
  public SecretVolumeSource getSecret() {
    return this.secret;
  }
  public A withSecret(SecretVolumeSource secret) {
    this.secret=secret; return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public String getSubPath() {
    return this.subPath;
  }
  public A withSubPath(String subPath) {
    this.subPath=subPath; return (A) this;
  }
  public Boolean hasSubPath() {
    return this.subPath != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumeClaimTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeClaim getVolumeClaimTemplate() {
    return this.volumeClaimTemplate!=null ?this.volumeClaimTemplate.build():null;
  }
  public PersistentVolumeClaim buildVolumeClaimTemplate() {
    return this.volumeClaimTemplate!=null ?this.volumeClaimTemplate.build():null;
  }
  public A withVolumeClaimTemplate(PersistentVolumeClaim volumeClaimTemplate) {
    _visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
    if (volumeClaimTemplate!=null){ this.volumeClaimTemplate= new PersistentVolumeClaimBuilder(volumeClaimTemplate); _visitables.get("volumeClaimTemplate").add(this.volumeClaimTemplate);} else { this.volumeClaimTemplate = null; _visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate); } return (A) this;
  }
  public Boolean hasVolumeClaimTemplate() {
    return this.volumeClaimTemplate != null;
  }
  public WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
    return new WorkspaceBindingFluentImpl.VolumeClaimTemplateNestedImpl();
  }
  public WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
    return new WorkspaceBindingFluentImpl.VolumeClaimTemplateNestedImpl(item);
  }
  public WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
    return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate());
  }
  public WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
    return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): new PersistentVolumeClaimBuilder().build());
  }
  public WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
    return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WorkspaceBindingFluentImpl that = (WorkspaceBindingFluentImpl) o;
    if (!java.util.Objects.equals(configMap, that.configMap)) return false;

    if (!java.util.Objects.equals(csi, that.csi)) return false;

    if (!java.util.Objects.equals(emptyDir, that.emptyDir)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;

    if (!java.util.Objects.equals(projected, that.projected)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(subPath, that.subPath)) return false;

    if (!java.util.Objects.equals(volumeClaimTemplate, that.volumeClaimTemplate)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMap,  csi,  emptyDir,  name,  persistentVolumeClaim,  projected,  secret,  subPath,  volumeClaimTemplate,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (csi != null) { sb.append("csi:"); sb.append(csi + ","); }
    if (emptyDir != null) { sb.append("emptyDir:"); sb.append(emptyDir + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (projected != null) { sb.append("projected:"); sb.append(projected + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (subPath != null) { sb.append("subPath:"); sb.append(subPath + ","); }
    if (volumeClaimTemplate != null) { sb.append("volumeClaimTemplate:"); sb.append(volumeClaimTemplate); }
    sb.append("}");
    return sb.toString();
  }
  class VolumeClaimTemplateNestedImpl<N> extends PersistentVolumeClaimFluentImpl<WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<N>> implements WorkspaceBindingFluentImpl.VolumeClaimTemplateNested<N>,Nested<N>{
    VolumeClaimTemplateNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    VolumeClaimTemplateNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) WorkspaceBindingFluentImpl.this.withVolumeClaimTemplate(builder.build());
    }
    public N endVolumeClaimTemplate() {
      return and();
    }
    
  }
  
}