package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkspacePipelineTaskBindingBuilder extends WorkspacePipelineTaskBindingFluentImpl<WorkspacePipelineTaskBindingBuilder> implements VisitableBuilder<WorkspacePipelineTaskBinding,WorkspacePipelineTaskBindingBuilder>{
  public WorkspacePipelineTaskBindingBuilder() {
    this(false);
  }
  public WorkspacePipelineTaskBindingBuilder(Boolean validationEnabled) {
    this(new WorkspacePipelineTaskBinding(), validationEnabled);
  }
  public WorkspacePipelineTaskBindingBuilder(WorkspacePipelineTaskBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkspacePipelineTaskBindingBuilder(WorkspacePipelineTaskBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkspacePipelineTaskBinding(), validationEnabled);
  }
  public WorkspacePipelineTaskBindingBuilder(WorkspacePipelineTaskBindingFluent<?> fluent,WorkspacePipelineTaskBinding instance) {
    this(fluent, instance, false);
  }
  public WorkspacePipelineTaskBindingBuilder(WorkspacePipelineTaskBindingFluent<?> fluent,WorkspacePipelineTaskBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withSubPath(instance.getSubPath());
      fluent.withWorkspace(instance.getWorkspace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkspacePipelineTaskBindingBuilder(WorkspacePipelineTaskBinding instance) {
    this(instance,false);
  }
  public WorkspacePipelineTaskBindingBuilder(WorkspacePipelineTaskBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withSubPath(instance.getSubPath());
      this.withWorkspace(instance.getWorkspace());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkspacePipelineTaskBindingFluent<?> fluent;
  Boolean validationEnabled;
  public WorkspacePipelineTaskBinding build() {
    WorkspacePipelineTaskBinding buildable = new WorkspacePipelineTaskBinding(fluent.getName(),fluent.getSubPath(),fluent.getWorkspace());
    return buildable;
  }
  
}