package io.fabric8.tekton.v1.internal.pipeline.pkg.apis.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureFlagsBuilder extends FeatureFlagsFluentImpl<FeatureFlagsBuilder> implements VisitableBuilder<FeatureFlags,FeatureFlagsBuilder>{
  public FeatureFlagsBuilder() {
    this(false);
  }
  public FeatureFlagsBuilder(Boolean validationEnabled) {
    this(new FeatureFlags(), validationEnabled);
  }
  public FeatureFlagsBuilder(FeatureFlagsFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureFlagsBuilder(FeatureFlagsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureFlags(), validationEnabled);
  }
  public FeatureFlagsBuilder(FeatureFlagsFluent<?> fluent,FeatureFlags instance) {
    this(fluent, instance, false);
  }
  public FeatureFlagsBuilder(FeatureFlagsFluent<?> fluent,FeatureFlags instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAwaitSidecarReadiness(instance.getAwaitSidecarReadiness());
      fluent.withDisableAffinityAssistant(instance.getDisableAffinityAssistant());
      fluent.withDisableCredsInit(instance.getDisableCredsInit());
      fluent.withEnableAPIFields(instance.getEnableAPIFields());
      fluent.withEnableProvenanceInStatus(instance.getEnableProvenanceInStatus());
      fluent.withEnableTektonOCIBundles(instance.getEnableTektonOCIBundles());
      fluent.withEnforceNonfalsifiability(instance.getEnforceNonfalsifiability());
      fluent.withMaxResultSize(instance.getMaxResultSize());
      fluent.withRequireGitSSHSecretKnownHosts(instance.getRequireGitSSHSecretKnownHosts());
      fluent.withResultExtractionMethod(instance.getResultExtractionMethod());
      fluent.withRunningInEnvWithInjectedSidecars(instance.getRunningInEnvWithInjectedSidecars());
      fluent.withScopeWhenExpressionsToTask(instance.getScopeWhenExpressionsToTask());
      fluent.withSendCloudEventsForRuns(instance.getSendCloudEventsForRuns());
      fluent.withVerificationNoMatchPolicy(instance.getVerificationNoMatchPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureFlagsBuilder(FeatureFlags instance) {
    this(instance,false);
  }
  public FeatureFlagsBuilder(FeatureFlags instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAwaitSidecarReadiness(instance.getAwaitSidecarReadiness());
      this.withDisableAffinityAssistant(instance.getDisableAffinityAssistant());
      this.withDisableCredsInit(instance.getDisableCredsInit());
      this.withEnableAPIFields(instance.getEnableAPIFields());
      this.withEnableProvenanceInStatus(instance.getEnableProvenanceInStatus());
      this.withEnableTektonOCIBundles(instance.getEnableTektonOCIBundles());
      this.withEnforceNonfalsifiability(instance.getEnforceNonfalsifiability());
      this.withMaxResultSize(instance.getMaxResultSize());
      this.withRequireGitSSHSecretKnownHosts(instance.getRequireGitSSHSecretKnownHosts());
      this.withResultExtractionMethod(instance.getResultExtractionMethod());
      this.withRunningInEnvWithInjectedSidecars(instance.getRunningInEnvWithInjectedSidecars());
      this.withScopeWhenExpressionsToTask(instance.getScopeWhenExpressionsToTask());
      this.withSendCloudEventsForRuns(instance.getSendCloudEventsForRuns());
      this.withVerificationNoMatchPolicy(instance.getVerificationNoMatchPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureFlagsFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureFlags build() {
    FeatureFlags buildable = new FeatureFlags(fluent.getAwaitSidecarReadiness(),fluent.getDisableAffinityAssistant(),fluent.getDisableCredsInit(),fluent.getEnableAPIFields(),fluent.getEnableProvenanceInStatus(),fluent.getEnableTektonOCIBundles(),fluent.getEnforceNonfalsifiability(),fluent.getMaxResultSize(),fluent.getRequireGitSSHSecretKnownHosts(),fluent.getResultExtractionMethod(),fluent.getRunningInEnvWithInjectedSidecars(),fluent.getScopeWhenExpressionsToTask(),fluent.getSendCloudEventsForRuns(),fluent.getVerificationNoMatchPolicy());
    return buildable;
  }
  
}