package io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface TemplateFluent<A extends TemplateFluent<A>> extends Fluent<A>{
  public Affinity getAffinity();
  public A withAffinity(Affinity affinity);
  public Boolean hasAffinity();
  public Boolean getAutomountServiceAccountToken();
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
  public Boolean hasAutomountServiceAccountToken();
  public PodDNSConfig getDnsConfig();
  public A withDnsConfig(PodDNSConfig dnsConfig);
  public Boolean hasDnsConfig();
  public String getDnsPolicy();
  public A withDnsPolicy(String dnsPolicy);
  public Boolean hasDnsPolicy();
  public Boolean getEnableServiceLinks();
  public A withEnableServiceLinks(Boolean enableServiceLinks);
  public Boolean hasEnableServiceLinks();
  public A addToEnv(int index,EnvVar item);
  public A setToEnv(int index,EnvVar item);
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
  public A addAllToEnv(Collection<EnvVar> items);
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
  public A removeAllFromEnv(Collection<EnvVar> items);
  public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EnvVar> getEnv();
  public List<EnvVar> buildEnv();
  public EnvVar buildEnv(int index);
  public EnvVar buildFirstEnv();
  public EnvVar buildLastEnv();
  public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate);
  public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate);
  public A withEnv(List<EnvVar> env);
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env);
  public Boolean hasEnv();
  public TemplateFluent.EnvNested<A> addNewEnv();
  public TemplateFluent.EnvNested<A> addNewEnvLike(EnvVar item);
  public TemplateFluent.EnvNested<A> setNewEnvLike(int index,EnvVar item);
  public TemplateFluent.EnvNested<A> editEnv(int index);
  public TemplateFluent.EnvNested<A> editFirstEnv();
  public TemplateFluent.EnvNested<A> editLastEnv();
  public TemplateFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate);
  public A addToHostAliases(int index,HostAlias item);
  public A setToHostAliases(int index,HostAlias item);
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A addAllToHostAliases(Collection<HostAlias> items);
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A removeAllFromHostAliases(Collection<HostAlias> items);
  public List<HostAlias> getHostAliases();
  public HostAlias getHostAlias(int index);
  public HostAlias getFirstHostAlias();
  public HostAlias getLastHostAlias();
  public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate);
  public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate);
  public A withHostAliases(List<HostAlias> hostAliases);
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases);
  public Boolean hasHostAliases();
  public Boolean getHostNetwork();
  public A withHostNetwork(Boolean hostNetwork);
  public Boolean hasHostNetwork();
  public A addToImagePullSecrets(int index,LocalObjectReference item);
  public A setToImagePullSecrets(int index,LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets();
  public List<LocalObjectReference> buildImagePullSecrets();
  public LocalObjectReference buildImagePullSecret(int index);
  public LocalObjectReference buildFirstImagePullSecret();
  public LocalObjectReference buildLastImagePullSecret();
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(String name);
  public TemplateFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public TemplateFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
  public TemplateFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item);
  public TemplateFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
  public TemplateFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public TemplateFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public TemplateFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  public String getPriorityClassName();
  public A withPriorityClassName(String priorityClassName);
  public Boolean hasPriorityClassName();
  public String getRuntimeClassName();
  public A withRuntimeClassName(String runtimeClassName);
  public Boolean hasRuntimeClassName();
  public String getSchedulerName();
  public A withSchedulerName(String schedulerName);
  public Boolean hasSchedulerName();
  public PodSecurityContext getSecurityContext();
  public A withSecurityContext(PodSecurityContext securityContext);
  public Boolean hasSecurityContext();
  public A addToTolerations(int index,Toleration item);
  public A setToTolerations(int index,Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(Collection<Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(Collection<Toleration> items);
  public List<Toleration> getTolerations();
  public Toleration getToleration(int index);
  public Toleration getFirstToleration();
  public Toleration getLastToleration();
  public Toleration getMatchingToleration(Predicate<Toleration> predicate);
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
  public A withTolerations(List<Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public Boolean hasTolerations();
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public List<TopologySpreadConstraint> getTopologySpreadConstraints();
  public TopologySpreadConstraint getTopologySpreadConstraint(int index);
  public TopologySpreadConstraint getFirstTopologySpreadConstraint();
  public TopologySpreadConstraint getLastTopologySpreadConstraint();
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public Boolean hasTopologySpreadConstraints();
  public A addToVolumes(int index,Volume item);
  public A setToVolumes(int index,Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(Collection<Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(Collection<Volume> items);
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes();
  public List<Volume> buildVolumes();
  public Volume buildVolume(int index);
  public Volume buildFirstVolume();
  public Volume buildLastVolume();
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A withVolumes(List<Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public Boolean hasVolumes();
  public TemplateFluent.VolumesNested<A> addNewVolume();
  public TemplateFluent.VolumesNested<A> addNewVolumeLike(Volume item);
  public TemplateFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
  public TemplateFluent.VolumesNested<A> editVolume(int index);
  public TemplateFluent.VolumesNested<A> editFirstVolume();
  public TemplateFluent.VolumesNested<A> editLastVolume();
  public TemplateFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A withAutomountServiceAccountToken();
  public A withEnableServiceLinks();
  public A withHostNetwork();
  public interface EnvNested<N> extends Nested<N>,EnvVarFluent<TemplateFluent.EnvNested<N>>{
    public N and();
    public N endEnv();
    
  }
  public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<TemplateFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface VolumesNested<N> extends Nested<N>,VolumeFluent<TemplateFluent.VolumesNested<N>>{
    public N and();
    public N endVolume();
    
  }
  
}