package io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TemplateFluentImpl<A extends TemplateFluent<A>> extends BaseFluent<A> implements TemplateFluent<A>{
  public TemplateFluentImpl() {
  }
  public TemplateFluentImpl(Template instance) {
    if (instance != null) {
      this.withAffinity(instance.getAffinity());
      this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
      this.withDnsConfig(instance.getDnsConfig());
      this.withDnsPolicy(instance.getDnsPolicy());
      this.withEnableServiceLinks(instance.getEnableServiceLinks());
      this.withEnv(instance.getEnv());
      this.withHostAliases(instance.getHostAliases());
      this.withHostNetwork(instance.getHostNetwork());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withNodeSelector(instance.getNodeSelector());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withRuntimeClassName(instance.getRuntimeClassName());
      this.withSchedulerName(instance.getSchedulerName());
      this.withSecurityContext(instance.getSecurityContext());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withVolumes(instance.getVolumes());
    }
  }
  private Affinity affinity;
  private Boolean automountServiceAccountToken;
  private PodDNSConfig dnsConfig;
  private String dnsPolicy;
  private Boolean enableServiceLinks;
  private ArrayList<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
  private List<HostAlias> hostAliases = new ArrayList<HostAlias>();
  private Boolean hostNetwork;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private Map<String,String> nodeSelector;
  private String priorityClassName;
  private String runtimeClassName;
  private String schedulerName;
  private PodSecurityContext securityContext;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
  private ArrayList<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  public Boolean getAutomountServiceAccountToken() {
    return this.automountServiceAccountToken;
  }
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
    this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
  }
  public Boolean hasAutomountServiceAccountToken() {
    return this.automountServiceAccountToken != null;
  }
  public PodDNSConfig getDnsConfig() {
    return this.dnsConfig;
  }
  public A withDnsConfig(PodDNSConfig dnsConfig) {
    this.dnsConfig=dnsConfig; return (A) this;
  }
  public Boolean hasDnsConfig() {
    return this.dnsConfig != null;
  }
  public String getDnsPolicy() {
    return this.dnsPolicy;
  }
  public A withDnsPolicy(String dnsPolicy) {
    this.dnsPolicy=dnsPolicy; return (A) this;
  }
  public Boolean hasDnsPolicy() {
    return this.dnsPolicy != null;
  }
  public Boolean getEnableServiceLinks() {
    return this.enableServiceLinks;
  }
  public A withEnableServiceLinks(Boolean enableServiceLinks) {
    this.enableServiceLinks=enableServiceLinks; return (A) this;
  }
  public Boolean hasEnableServiceLinks() {
    return this.enableServiceLinks != null;
  }
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<EnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EnvVar> getEnv() {
    return env != null ? build(env) : null;
  }
  public List<EnvVar> buildEnv() {
    return env != null ? build(env) : null;
  }
  public EnvVar buildEnv(int index) {
    return this.env.get(index).build();
  }
  public EnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  public EnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    for (EnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    for (EnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (this.env != null) { _visitables.get("env").clear();}
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public TemplateFluentImpl.EnvNested<A> addNewEnv() {
    return new TemplateFluentImpl.EnvNestedImpl();
  }
  public TemplateFluentImpl.EnvNested<A> addNewEnvLike(EnvVar item) {
    return new TemplateFluentImpl.EnvNestedImpl(-1, item);
  }
  public TemplateFluentImpl.EnvNested<A> setNewEnvLike(int index,EnvVar item) {
    return new TemplateFluentImpl.EnvNestedImpl(index, item);
  }
  public TemplateFluentImpl.EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public TemplateFluentImpl.EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public TemplateFluentImpl.EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public TemplateFluentImpl.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public A addToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    this.hostAliases.add(index, item);
    return (A)this;
  }
  public A setToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    this.hostAliases.set(index, item); return (A)this;
  }
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A addAllToHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    for (HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
  }
  public A removeAllFromHostAliases(Collection<HostAlias> items) {
    for (HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
  }
  public List<HostAlias> getHostAliases() {
    return this.hostAliases;
  }
  public HostAlias getHostAlias(int index) {
    return this.hostAliases.get(index);
  }
  public HostAlias getFirstHostAlias() {
    return this.hostAliases.get(0);
  }
  public HostAlias getLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1);
  }
  public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
    for (HostAlias item: hostAliases) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
    for (HostAlias item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostAliases(List<HostAlias> hostAliases) {
    if (hostAliases != null) {this.hostAliases = new ArrayList(); for (HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
  }
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases) {
    if (this.hostAliases != null) {this.hostAliases.clear(); _visitables.remove("hostAliases"); }
    if (hostAliases != null) {for (HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
  }
  public Boolean hasHostAliases() {
    return hostAliases != null && !hostAliases.isEmpty();
  }
  public Boolean getHostNetwork() {
    return this.hostNetwork;
  }
  public A withHostNetwork(Boolean hostNetwork) {
    this.hostNetwork=hostNetwork; return (A) this;
  }
  public Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public A addToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").add(index, builder); imagePullSecrets.add(index, builder);}
    return (A)this;
  }
  public A setToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder); imagePullSecrets.set(index, builder);}
    return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public LocalObjectReference buildImagePullSecret(int index) {
    return this.imagePullSecrets.get(index).build();
  }
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").clear();}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear(); _visitables.remove("imagePullSecrets"); }
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new TemplateFluentImpl.ImagePullSecretsNestedImpl();
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new TemplateFluentImpl.ImagePullSecretsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
    return new TemplateFluentImpl.ImagePullSecretsNestedImpl(index, item);
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> editImagePullSecret(int index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public TemplateFluentImpl.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public String getRuntimeClassName() {
    return this.runtimeClassName;
  }
  public A withRuntimeClassName(String runtimeClassName) {
    this.runtimeClassName=runtimeClassName; return (A) this;
  }
  public Boolean hasRuntimeClassName() {
    return this.runtimeClassName != null;
  }
  public String getSchedulerName() {
    return this.schedulerName;
  }
  public A withSchedulerName(String schedulerName) {
    this.schedulerName=schedulerName; return (A) this;
  }
  public Boolean hasSchedulerName() {
    return this.schedulerName != null;
  }
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
    return this.topologySpreadConstraints.get(index);
  }
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear(); _visitables.remove("topologySpreadConstraints"); }
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").set(index, builder); volumes.set(index, builder);}
    return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public List<Volume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public Volume buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  public Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").clear();}
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public TemplateFluentImpl.VolumesNested<A> addNewVolume() {
    return new TemplateFluentImpl.VolumesNestedImpl();
  }
  public TemplateFluentImpl.VolumesNested<A> addNewVolumeLike(Volume item) {
    return new TemplateFluentImpl.VolumesNestedImpl(-1, item);
  }
  public TemplateFluentImpl.VolumesNested<A> setNewVolumeLike(int index,Volume item) {
    return new TemplateFluentImpl.VolumesNestedImpl(index, item);
  }
  public TemplateFluentImpl.VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public TemplateFluentImpl.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public TemplateFluentImpl.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public TemplateFluentImpl.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateFluentImpl that = (TemplateFluentImpl) o;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;

    if (!java.util.Objects.equals(automountServiceAccountToken, that.automountServiceAccountToken)) return false;

    if (!java.util.Objects.equals(dnsConfig, that.dnsConfig)) return false;

    if (!java.util.Objects.equals(dnsPolicy, that.dnsPolicy)) return false;

    if (!java.util.Objects.equals(enableServiceLinks, that.enableServiceLinks)) return false;

    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(hostAliases, that.hostAliases)) return false;

    if (!java.util.Objects.equals(hostNetwork, that.hostNetwork)) return false;

    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(priorityClassName, that.priorityClassName)) return false;

    if (!java.util.Objects.equals(runtimeClassName, that.runtimeClassName)) return false;

    if (!java.util.Objects.equals(schedulerName, that.schedulerName)) return false;

    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    if (!java.util.Objects.equals(topologySpreadConstraints, that.topologySpreadConstraints)) return false;

    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinity,  automountServiceAccountToken,  dnsConfig,  dnsPolicy,  enableServiceLinks,  env,  hostAliases,  hostNetwork,  imagePullSecrets,  nodeSelector,  priorityClassName,  runtimeClassName,  schedulerName,  securityContext,  tolerations,  topologySpreadConstraints,  volumes,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (automountServiceAccountToken != null) { sb.append("automountServiceAccountToken:"); sb.append(automountServiceAccountToken + ","); }
    if (dnsConfig != null) { sb.append("dnsConfig:"); sb.append(dnsConfig + ","); }
    if (dnsPolicy != null) { sb.append("dnsPolicy:"); sb.append(dnsPolicy + ","); }
    if (enableServiceLinks != null) { sb.append("enableServiceLinks:"); sb.append(enableServiceLinks + ","); }
    if (env != null) { sb.append("env:"); sb.append(env + ","); }
    if (hostAliases != null && !hostAliases.isEmpty()) { sb.append("hostAliases:"); sb.append(hostAliases + ","); }
    if (hostNetwork != null) { sb.append("hostNetwork:"); sb.append(hostNetwork + ","); }
    if (imagePullSecrets != null) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (runtimeClassName != null) { sb.append("runtimeClassName:"); sb.append(runtimeClassName + ","); }
    if (schedulerName != null) { sb.append("schedulerName:"); sb.append(schedulerName + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (volumes != null) { sb.append("volumes:"); sb.append(volumes); }
    sb.append("}");
    return sb.toString();
  }
  public A withAutomountServiceAccountToken() {
    return withAutomountServiceAccountToken(true);
  }
  public A withEnableServiceLinks() {
    return withEnableServiceLinks(true);
  }
  public A withHostNetwork() {
    return withHostNetwork(true);
  }
  class EnvNestedImpl<N> extends EnvVarFluentImpl<TemplateFluentImpl.EnvNested<N>> implements TemplateFluentImpl.EnvNested<N>,Nested<N>{
    EnvNestedImpl(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvNestedImpl() {
      this.index = -1;
      this.builder = new EnvVarBuilder(this);
    }
    EnvVarBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<TemplateFluentImpl.ImagePullSecretsNested<N>> implements TemplateFluentImpl.ImagePullSecretsNested<N>,Nested<N>{
    ImagePullSecretsNestedImpl(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ImagePullSecretsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends VolumeFluentImpl<TemplateFluentImpl.VolumesNested<N>> implements TemplateFluentImpl.VolumesNested<N>,Nested<N>{
    VolumesNestedImpl(int index,Volume item) {
      this.index = index;
      this.builder = new VolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new VolumeBuilder(this);
    }
    VolumeBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}