/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.tekton.pipeline.v1.TaskRun;
import io.fabric8.tekton.pipeline.v1.TaskRunFluent;
import io.fabric8.tekton.pipeline.v1.TaskRunSpec;
import io.fabric8.tekton.pipeline.v1.TaskRunSpecBuilder;
import io.fabric8.tekton.pipeline.v1.TaskRunSpecFluentImpl;
import io.fabric8.tekton.pipeline.v1.TaskRunStatus;
import io.fabric8.tekton.pipeline.v1.TaskRunStatusBuilder;
import io.fabric8.tekton.pipeline.v1.TaskRunStatusFluentImpl;
import java.util.Objects;

public class TaskRunFluentImpl<A extends TaskRunFluent<A>>
extends BaseFluent<A>
implements TaskRunFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private TaskRunSpecBuilder spec;
    private TaskRunStatusBuilder status;

    public TaskRunFluentImpl() {
    }

    public TaskRunFluentImpl(TaskRun instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public TaskRunFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public TaskRunFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public TaskRunFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public TaskRunFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public TaskRunFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public TaskRunSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public TaskRunSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(TaskRunSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new TaskRunSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public TaskRunFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public TaskRunFluent.SpecNested<A> withNewSpecLike(TaskRunSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public TaskRunFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public TaskRunFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new TaskRunSpecBuilder().build());
    }

    @Override
    public TaskRunFluent.SpecNested<A> editOrNewSpecLike(TaskRunSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public TaskRunStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public TaskRunStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(TaskRunStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new TaskRunStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public TaskRunFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public TaskRunFluent.StatusNested<A> withNewStatusLike(TaskRunStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public TaskRunFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public TaskRunFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new TaskRunStatusBuilder().build());
    }

    @Override
    public TaskRunFluent.StatusNested<A> editOrNewStatusLike(TaskRunStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskRunFluentImpl that = (TaskRunFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends TaskRunStatusFluentImpl<TaskRunFluent.StatusNested<N>>
    implements TaskRunFluent.StatusNested<N>,
    Nested<N> {
        TaskRunStatusBuilder builder;

        StatusNestedImpl(TaskRunStatus item) {
            this.builder = new TaskRunStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new TaskRunStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends TaskRunSpecFluentImpl<TaskRunFluent.SpecNested<N>>
    implements TaskRunFluent.SpecNested<N>,
    Nested<N> {
        TaskRunSpecBuilder builder;

        SpecNestedImpl(TaskRunSpec item) {
            this.builder = new TaskRunSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new TaskRunSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<TaskRunFluent.MetadataNested<N>>
    implements TaskRunFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)TaskRunFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

