/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.tekton.pipeline.v1alpha1.Inputs;
import io.fabric8.tekton.pipeline.v1alpha1.InputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.InputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.Outputs;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResult;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResultBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResultFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpec;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpecFluent;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.Step;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.StepBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.StepFluentImpl;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceDeclaration;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceDeclarationBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceDeclarationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TaskSpecFluentImpl<A extends TaskSpecFluent<A>>
extends BaseFluent<A>
implements TaskSpecFluent<A> {
    private InputsBuilder inputs;
    private OutputsBuilder outputs;
    private List<TaskResultBuilder> results;
    private List<Container> sidecars;
    private Container stepTemplate;
    private List<StepBuilder> steps;
    private List<Volume> volumes;
    private List<WorkspaceDeclarationBuilder> workspaces;

    public TaskSpecFluentImpl() {
    }

    public TaskSpecFluentImpl(TaskSpec instance) {
        this.withInputs(instance.getInputs());
        this.withOutputs(instance.getOutputs());
        this.withResults(instance.getResults());
        this.withSidecars(instance.getSidecars());
        this.withStepTemplate(instance.getStepTemplate());
        this.withSteps(instance.getSteps());
        this.withVolumes(instance.getVolumes());
        this.withWorkspaces(instance.getWorkspaces());
    }

    @Override
    @Deprecated
    public Inputs getInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public Inputs buildInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public A withInputs(Inputs inputs) {
        this._visitables.get((Object)"inputs").remove(this.inputs);
        if (inputs != null) {
            this.inputs = new InputsBuilder(inputs);
            this._visitables.get((Object)"inputs").add(this.inputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInputs() {
        return this.inputs != null;
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputs() {
        return new InputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputsLike(Inputs item) {
        return new InputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editInputs() {
        return this.withNewInputsLike(this.getInputs());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputs() {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : new InputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputsLike(Inputs item) {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : item);
    }

    @Override
    @Deprecated
    public Outputs getOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public Outputs buildOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public A withOutputs(Outputs outputs) {
        this._visitables.get((Object)"outputs").remove(this.outputs);
        if (outputs != null) {
            this.outputs = new OutputsBuilder(outputs);
            this._visitables.get((Object)"outputs").add(this.outputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutputs() {
        return this.outputs != null;
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputs() {
        return new OutputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputsLike(Outputs item) {
        return new OutputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOutputs() {
        return this.withNewOutputsLike(this.getOutputs());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputs() {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : new OutputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputsLike(Outputs item) {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : item);
    }

    @Override
    public A addToResults(int index, TaskResult item) {
        if (this.results == null) {
            this.results = new ArrayList<TaskResultBuilder>();
        }
        TaskResultBuilder builder = new TaskResultBuilder(item);
        this._visitables.get((Object)"results").add(index >= 0 ? index : this._visitables.get((Object)"results").size(), builder);
        this.results.add(index >= 0 ? index : this.results.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResults(int index, TaskResult item) {
        if (this.results == null) {
            this.results = new ArrayList<TaskResultBuilder>();
        }
        TaskResultBuilder builder = new TaskResultBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"results").size()) {
            this._visitables.get((Object)"results").add(builder);
        } else {
            this._visitables.get((Object)"results").set(index, builder);
        }
        if (index < 0 || index >= this.results.size()) {
            this.results.add(builder);
        } else {
            this.results.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResults(TaskResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList<TaskResultBuilder>();
        }
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResults(Collection<TaskResult> items) {
        if (this.results == null) {
            this.results = new ArrayList<TaskResultBuilder>();
        }
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResults(TaskResult ... items) {
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResults(Collection<TaskResult> items) {
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResults(Predicate<TaskResultBuilder> predicate) {
        if (this.results == null) {
            return (A)this;
        }
        Iterator<TaskResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            TaskResultBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TaskResult> getResults() {
        return TaskSpecFluentImpl.build(this.results);
    }

    @Override
    public List<TaskResult> buildResults() {
        return TaskSpecFluentImpl.build(this.results);
    }

    @Override
    public TaskResult buildResult(int index) {
        return this.results.get(index).build();
    }

    @Override
    public TaskResult buildFirstResult() {
        return this.results.get(0).build();
    }

    @Override
    public TaskResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    @Override
    public TaskResult buildMatchingResult(Predicate<TaskResultBuilder> predicate) {
        for (TaskResultBuilder item : this.results) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResult(Predicate<TaskResultBuilder> predicate) {
        for (TaskResultBuilder item : this.results) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResults(List<TaskResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").removeAll(this.results);
        }
        if (results != null) {
            this.results = new ArrayList<TaskResultBuilder>();
            for (TaskResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)this;
    }

    @Override
    public A withResults(TaskResult ... results) {
        if (this.results != null) {
            this.results.clear();
        }
        if (results != null) {
            for (TaskResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    @Override
    public A addNewResult(String description, String name) {
        return this.addToResults(new TaskResult(description, name));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> addNewResultLike(TaskResult item) {
        return new ResultsNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> setNewResultLike(int index, TaskResult item) {
        return new ResultsNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editMatchingResult(Predicate<TaskResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.apply((Object)this.results.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public A addToSidecars(int index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        this.sidecars.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSidecars(int index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        this.sidecars.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSidecars(Container ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.sidecars.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSidecars(Collection<Container> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.sidecars.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSidecars(Container ... items) {
        for (Container item : items) {
            if (this.sidecars == null) continue;
            this.sidecars.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSidecars(Collection<Container> items) {
        for (Container item : items) {
            if (this.sidecars == null) continue;
            this.sidecars.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Container> getSidecars() {
        return this.sidecars;
    }

    @Override
    public Container getSidecar(int index) {
        return this.sidecars.get(index);
    }

    @Override
    public Container getFirstSidecar() {
        return this.sidecars.get(0);
    }

    @Override
    public Container getLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1);
    }

    @Override
    public Container getMatchingSidecar(Predicate<Container> predicate) {
        for (Container item : this.sidecars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSidecar(Predicate<Container> predicate) {
        for (Container item : this.sidecars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSidecars(List<Container> sidecars) {
        if (this.sidecars != null) {
            this._visitables.get((Object)"sidecars").removeAll(this.sidecars);
        }
        if (sidecars != null) {
            this.sidecars = new ArrayList<Container>();
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        } else {
            this.sidecars = null;
        }
        return (A)this;
    }

    @Override
    public A withSidecars(Container ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
        }
        if (sidecars != null) {
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    @Override
    public Container getStepTemplate() {
        return this.stepTemplate;
    }

    @Override
    public A withStepTemplate(Container stepTemplate) {
        this.stepTemplate = stepTemplate;
        return (A)this;
    }

    @Override
    public Boolean hasStepTemplate() {
        return this.stepTemplate != null;
    }

    @Override
    public A addToSteps(int index, Step item) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        StepBuilder builder = new StepBuilder(item);
        this._visitables.get((Object)"steps").add(index >= 0 ? index : this._visitables.get((Object)"steps").size(), builder);
        this.steps.add(index >= 0 ? index : this.steps.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSteps(int index, Step item) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        StepBuilder builder = new StepBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"steps").size()) {
            this._visitables.get((Object)"steps").add(builder);
        } else {
            this._visitables.get((Object)"steps").set(index, builder);
        }
        if (index < 0 || index >= this.steps.size()) {
            this.steps.add(builder);
        } else {
            this.steps.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSteps(Step ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<Step> items) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(Step ... items) {
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<Step> items) {
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSteps(Predicate<StepBuilder> predicate) {
        if (this.steps == null) {
            return (A)this;
        }
        Iterator<StepBuilder> each = this.steps.iterator();
        List visitables = this._visitables.get((Object)"steps");
        while (each.hasNext()) {
            StepBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Step> getSteps() {
        return TaskSpecFluentImpl.build(this.steps);
    }

    @Override
    public List<Step> buildSteps() {
        return TaskSpecFluentImpl.build(this.steps);
    }

    @Override
    public Step buildStep(int index) {
        return this.steps.get(index).build();
    }

    @Override
    public Step buildFirstStep() {
        return this.steps.get(0).build();
    }

    @Override
    public Step buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    @Override
    public Step buildMatchingStep(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.steps) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.steps) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<Step> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").removeAll(this.steps);
        }
        if (steps != null) {
            this.steps = new ArrayList<StepBuilder>();
            for (Step item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    @Override
    public A withSteps(Step ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (Step item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public TaskSpecFluent.StepsNested<A> addNewStep() {
        return new StepsNestedImpl();
    }

    @Override
    public TaskSpecFluent.StepsNested<A> addNewStepLike(Step item) {
        return new StepsNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.StepsNested<A> setNewStepLike(int index, Step item) {
        return new StepsNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editMatchingStep(Predicate<StepBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.apply((Object)this.steps.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public A addToWorkspaces(int index, WorkspaceDeclaration item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();
        }
        WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
        this._visitables.get((Object)"workspaces").add(index >= 0 ? index : this._visitables.get((Object)"workspaces").size(), builder);
        this.workspaces.add(index >= 0 ? index : this.workspaces.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWorkspaces(int index, WorkspaceDeclaration item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();
        }
        WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"workspaces").size()) {
            this._visitables.get((Object)"workspaces").add(builder);
        } else {
            this._visitables.get((Object)"workspaces").set(index, builder);
        }
        if (index < 0 || index >= this.workspaces.size()) {
            this.workspaces.add(builder);
        } else {
            this.workspaces.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWorkspaces(WorkspaceDeclaration ... items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();
        }
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWorkspaces(Collection<WorkspaceDeclaration> items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();
        }
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkspaces(WorkspaceDeclaration ... items) {
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").remove(builder);
            if (this.workspaces == null) continue;
            this.workspaces.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWorkspaces(Collection<WorkspaceDeclaration> items) {
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").remove(builder);
            if (this.workspaces == null) continue;
            this.workspaces.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWorkspaces(Predicate<WorkspaceDeclarationBuilder> predicate) {
        if (this.workspaces == null) {
            return (A)this;
        }
        Iterator<WorkspaceDeclarationBuilder> each = this.workspaces.iterator();
        List visitables = this._visitables.get((Object)"workspaces");
        while (each.hasNext()) {
            WorkspaceDeclarationBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<WorkspaceDeclaration> getWorkspaces() {
        return TaskSpecFluentImpl.build(this.workspaces);
    }

    @Override
    public List<WorkspaceDeclaration> buildWorkspaces() {
        return TaskSpecFluentImpl.build(this.workspaces);
    }

    @Override
    public WorkspaceDeclaration buildWorkspace(int index) {
        return this.workspaces.get(index).build();
    }

    @Override
    public WorkspaceDeclaration buildFirstWorkspace() {
        return this.workspaces.get(0).build();
    }

    @Override
    public WorkspaceDeclaration buildLastWorkspace() {
        return this.workspaces.get(this.workspaces.size() - 1).build();
    }

    @Override
    public WorkspaceDeclaration buildMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
        for (WorkspaceDeclarationBuilder item : this.workspaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
        for (WorkspaceDeclarationBuilder item : this.workspaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWorkspaces(List<WorkspaceDeclaration> workspaces) {
        if (this.workspaces != null) {
            this._visitables.get((Object)"workspaces").removeAll(this.workspaces);
        }
        if (workspaces != null) {
            this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();
            for (WorkspaceDeclaration item : workspaces) {
                this.addToWorkspaces(item);
            }
        } else {
            this.workspaces = null;
        }
        return (A)this;
    }

    @Override
    public A withWorkspaces(WorkspaceDeclaration ... workspaces) {
        if (this.workspaces != null) {
            this.workspaces.clear();
        }
        if (workspaces != null) {
            for (WorkspaceDeclaration item : workspaces) {
                this.addToWorkspaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkspaces() {
        return this.workspaces != null && !this.workspaces.isEmpty();
    }

    @Override
    public A addNewWorkspace(String description, String mountPath, String name, Boolean readOnly) {
        return this.addToWorkspaces(new WorkspaceDeclaration(description, mountPath, name, readOnly));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> addNewWorkspace() {
        return new WorkspacesNestedImpl();
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> addNewWorkspaceLike(WorkspaceDeclaration item) {
        return new WorkspacesNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> setNewWorkspaceLike(int index, WorkspaceDeclaration item) {
        return new WorkspacesNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editWorkspace(int index) {
        if (this.workspaces.size() <= index) {
            throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editFirstWorkspace() {
        if (this.workspaces.size() == 0) {
            throw new RuntimeException("Can't edit first workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(0, this.buildWorkspace(0));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editLastWorkspace() {
        int index = this.workspaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workspaces.size(); ++i) {
            if (!predicate.apply((Object)this.workspaces.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching workspaces. No match found.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSpecFluentImpl that = (TaskSpecFluentImpl)o;
        if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) {
            return false;
        }
        if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(that.results) : that.results != null) {
            return false;
        }
        if (this.sidecars != null ? !this.sidecars.equals(that.sidecars) : that.sidecars != null) {
            return false;
        }
        if (this.stepTemplate != null ? !this.stepTemplate.equals((Object)that.stepTemplate) : that.stepTemplate != null) {
            return false;
        }
        if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.workspaces != null ? !this.workspaces.equals(that.workspaces) : that.workspaces != null);
    }

    public class WorkspacesNestedImpl<N>
    extends WorkspaceDeclarationFluentImpl<TaskSpecFluent.WorkspacesNested<N>>
    implements TaskSpecFluent.WorkspacesNested<N>,
    Nested<N> {
        private final WorkspaceDeclarationBuilder builder;
        private final int index;

        WorkspacesNestedImpl(int index, WorkspaceDeclaration item) {
            this.index = index;
            this.builder = new WorkspaceDeclarationBuilder(this, item);
        }

        WorkspacesNestedImpl() {
            this.index = -1;
            this.builder = new WorkspaceDeclarationBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToWorkspaces(this.index, this.builder.build());
        }

        @Override
        public N endWorkspace() {
            return this.and();
        }
    }

    public class StepsNestedImpl<N>
    extends StepFluentImpl<TaskSpecFluent.StepsNested<N>>
    implements TaskSpecFluent.StepsNested<N>,
    Nested<N> {
        private final StepBuilder builder;
        private final int index;

        StepsNestedImpl(int index, Step item) {
            this.index = index;
            this.builder = new StepBuilder(this, item);
        }

        StepsNestedImpl() {
            this.index = -1;
            this.builder = new StepBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToSteps(this.index, this.builder.build());
        }

        @Override
        public N endStep() {
            return this.and();
        }
    }

    public class ResultsNestedImpl<N>
    extends TaskResultFluentImpl<TaskSpecFluent.ResultsNested<N>>
    implements TaskSpecFluent.ResultsNested<N>,
    Nested<N> {
        private final TaskResultBuilder builder;
        private final int index;

        ResultsNestedImpl(int index, TaskResult item) {
            this.index = index;
            this.builder = new TaskResultBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.index = -1;
            this.builder = new TaskResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToResults(this.index, this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }

    public class OutputsNestedImpl<N>
    extends OutputsFluentImpl<TaskSpecFluent.OutputsNested<N>>
    implements TaskSpecFluent.OutputsNested<N>,
    Nested<N> {
        private final OutputsBuilder builder;

        OutputsNestedImpl(Outputs item) {
            this.builder = new OutputsBuilder(this, item);
        }

        OutputsNestedImpl() {
            this.builder = new OutputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withOutputs(this.builder.build());
        }

        @Override
        public N endOutputs() {
            return this.and();
        }
    }

    public class InputsNestedImpl<N>
    extends InputsFluentImpl<TaskSpecFluent.InputsNested<N>>
    implements TaskSpecFluent.InputsNested<N>,
    Nested<N> {
        private final InputsBuilder builder;

        InputsNestedImpl(Inputs item) {
            this.builder = new InputsBuilder(this, item);
        }

        InputsNestedImpl() {
            this.builder = new InputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withInputs(this.builder.build());
        }

        @Override
        public N endInputs() {
            return this.and();
        }
    }
}

