/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"arrayVal", "stringVal", "type"})
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ArrayOrString
implements KubernetesResource {
    private static final String TYPE_STRING = "string";
    private static final String TYPE_ARRAY = "array";
    @JsonProperty(value="arrayVal")
    private List<String> arrayVal = new ArrayList<String>();
    @JsonProperty(value="stringVal")
    private String stringVal;
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ArrayOrString() {
    }

    public ArrayOrString(List<String> arrayVal, String stringVal, String type, Map<String, Object> additionalProperties) {
        this.arrayVal = arrayVal;
        this.stringVal = stringVal;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    public ArrayOrString(String stringVal) {
        this(null, stringVal, TYPE_STRING, new HashMap<String, Object>());
    }

    public ArrayOrString(List<String> arrayVal) {
        this(arrayVal, null, TYPE_ARRAY, new HashMap<String, Object>());
    }

    @JsonProperty(value="arrayVal")
    public List<String> getArrayVal() {
        return this.arrayVal;
    }

    @JsonProperty(value="arrayVal")
    public void setArrayVal(List<String> arrayVal) {
        this.arrayVal = arrayVal;
    }

    @JsonProperty(value="stringVal")
    public String getStringVal() {
        return this.stringVal;
    }

    @JsonProperty(value="stringVal")
    public void setStringVal(String stringVal) {
        this.stringVal = stringVal;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ArrayOrString(arrayVal=" + this.getArrayVal() + ", stringVal=" + this.getStringVal() + ", type=" + this.getType() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayOrString)) {
            return false;
        }
        ArrayOrString other = (ArrayOrString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$arrayVal = this.getArrayVal();
        List<String> other$arrayVal = other.getArrayVal();
        if (this$arrayVal == null ? other$arrayVal != null : !((Object)this$arrayVal).equals(other$arrayVal)) {
            return false;
        }
        String this$stringVal = this.getStringVal();
        String other$stringVal = other.getStringVal();
        if (this$stringVal == null ? other$stringVal != null : !this$stringVal.equals(other$stringVal)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArrayOrString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $arrayVal = this.getArrayVal();
        result = result * 59 + ($arrayVal == null ? 43 : ((Object)$arrayVal).hashCode());
        String $stringVal = this.getStringVal();
        result = result * 59 + ($stringVal == null ? 43 : $stringVal.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static class Deserializer
    extends JsonDeserializer<ArrayOrString> {
        public ArrayOrString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ArrayOrString arrayOrString;
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (node.isArray()) {
                ArrayList<String> elements = new ArrayList<String>();
                node.elements().forEachRemaining(n -> elements.add(n.asText()));
                arrayOrString = new ArrayOrString(elements);
            } else {
                arrayOrString = new ArrayOrString(node.asText());
            }
            return arrayOrString;
        }
    }

    public static class Serializer
    extends JsonSerializer<ArrayOrString> {
        public void serialize(ArrayOrString value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                if (value.getType() == null) {
                    String stringVal = value.getStringVal();
                    if (stringVal != null) {
                        jgen.writeString(stringVal);
                    } else {
                        List<String> arrayVal = value.getArrayVal();
                        if (arrayVal != null) {
                            this.writeArray(value, jgen);
                        } else {
                            jgen.writeNull();
                        }
                    }
                } else if (Objects.equals(value.getType(), ArrayOrString.TYPE_STRING)) {
                    jgen.writeString(value.stringVal);
                } else if (Objects.equals(value.getType(), ArrayOrString.TYPE_ARRAY)) {
                    this.writeArray(value, jgen);
                } else {
                    jgen.writeNull();
                }
            } else {
                jgen.writeNull();
            }
        }

        private void writeArray(ArrayOrString value, JsonGenerator jgen) throws IOException {
            jgen.writeStartArray(value.getArrayVal().size());
            for (String n : value.getArrayVal()) {
                jgen.writeString(n);
            }
            jgen.writeEndArray();
        }
    }
}

