/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.resolution.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.resolution.v1alpha1.ResolutionRequestStatus;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1beta1.RefSource;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1beta1.RefSourceBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1beta1.RefSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResolutionRequestStatusFluent<A extends ResolutionRequestStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String data;
    private Long observedGeneration;
    private RefSourceBuilder refSource;
    private Map<String, Object> additionalProperties;

    public ResolutionRequestStatusFluent() {
    }

    public ResolutionRequestStatusFluent(ResolutionRequestStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResolutionRequestStatus instance) {
        ResolutionRequestStatus resolutionRequestStatus = instance = instance != null ? instance : new ResolutionRequestStatus();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withData(instance.getData());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withRefSource(instance.getRefSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getData() {
        return this.data;
    }

    public A withData(String data) {
        this.data = data;
        return (A)((Object)this);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public RefSource buildRefSource() {
        return this.refSource != null ? this.refSource.build() : null;
    }

    public A withRefSource(RefSource refSource) {
        this._visitables.remove((Object)"refSource");
        if (refSource != null) {
            this.refSource = new RefSourceBuilder(refSource);
            this._visitables.get((Object)"refSource").add(this.refSource);
        } else {
            this.refSource = null;
            this._visitables.get((Object)"refSource").remove((Object)this.refSource);
        }
        return (A)((Object)this);
    }

    public boolean hasRefSource() {
        return this.refSource != null;
    }

    public RefSourceNested<A> withNewRefSource() {
        return new RefSourceNested(null);
    }

    public RefSourceNested<A> withNewRefSourceLike(RefSource item) {
        return new RefSourceNested(item);
    }

    public RefSourceNested<A> editRefSource() {
        return this.withNewRefSourceLike(Optional.ofNullable(this.buildRefSource()).orElse(null));
    }

    public RefSourceNested<A> editOrNewRefSource() {
        return this.withNewRefSourceLike(Optional.ofNullable(this.buildRefSource()).orElse(new RefSourceBuilder().build()));
    }

    public RefSourceNested<A> editOrNewRefSourceLike(RefSource item) {
        return this.withNewRefSourceLike(Optional.ofNullable(this.buildRefSource()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResolutionRequestStatusFluent that = (ResolutionRequestStatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals((Object)this.refSource, (Object)that.refSource)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.conditions, this.data, this.observedGeneration, this.refSource, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.refSource != null) {
            sb.append("refSource:");
            sb.append((Object)((Object)this.refSource) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RefSourceNested<N>
    extends RefSourceFluent<RefSourceNested<N>>
    implements Nested<N> {
        RefSourceBuilder builder;

        RefSourceNested(RefSource item) {
            this.builder = new RefSourceBuilder(this, item);
        }

        public N and() {
            return (N)ResolutionRequestStatusFluent.this.withRefSource(this.builder.build());
        }

        public N endRefSource() {
            return this.and();
        }
    }
}

