/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.tekton.pipeline.v1alpha1.KeyRef;
import io.fabric8.tekton.pipeline.v1alpha1.KeyRefFluent;
import java.util.Objects;

public class KeyRefFluentImpl<A extends KeyRefFluent<A>>
extends BaseFluent<A>
implements KeyRefFluent<A> {
    private String data;
    private String hashAlgorithm;
    private String kms;
    private SecretReference secretRef;

    public KeyRefFluentImpl() {
    }

    public KeyRefFluentImpl(KeyRef instance) {
        if (instance != null) {
            this.withData(instance.getData());
            this.withHashAlgorithm(instance.getHashAlgorithm());
            this.withKms(instance.getKms());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public A withData(String data) {
        this.data = data;
        return (A)this;
    }

    @Override
    public Boolean hasData() {
        return this.data != null;
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public A withHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return (A)this;
    }

    @Override
    public Boolean hasHashAlgorithm() {
        return this.hashAlgorithm != null;
    }

    @Override
    public String getKms() {
        return this.kms;
    }

    @Override
    public A withKms(String kms) {
        this.kms = kms;
        return (A)this;
    }

    @Override
    public Boolean hasKms() {
        return this.kms != null;
    }

    @Override
    public SecretReference getSecretRef() {
        return this.secretRef;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this.secretRef = secretRef;
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyRefFluentImpl that = (KeyRefFluentImpl)o;
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        if (!Objects.equals(this.hashAlgorithm, that.hashAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.kms, that.kms)) {
            return false;
        }
        return Objects.equals(this.secretRef, that.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.hashAlgorithm, this.kms, this.secretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data + ",");
        }
        if (this.hashAlgorithm != null) {
            sb.append("hashAlgorithm:");
            sb.append(this.hashAlgorithm + ",");
        }
        if (this.kms != null) {
            sb.append("kms:");
            sb.append(this.kms + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }
}

