/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.pipeline.v1alpha1.Authority;
import io.fabric8.tekton.pipeline.v1alpha1.AuthorityBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.AuthorityFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.ResourcePattern;
import io.fabric8.tekton.pipeline.v1alpha1.ResourcePatternBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.ResourcePatternFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.VerificationPolicySpec;
import io.fabric8.tekton.pipeline.v1alpha1.VerificationPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class VerificationPolicySpecFluentImpl<A extends VerificationPolicySpecFluent<A>>
extends BaseFluent<A>
implements VerificationPolicySpecFluent<A> {
    private ArrayList<AuthorityBuilder> authorities = new ArrayList();
    private String mode;
    private ArrayList<ResourcePatternBuilder> resources = new ArrayList();

    public VerificationPolicySpecFluentImpl() {
    }

    public VerificationPolicySpecFluentImpl(VerificationPolicySpec instance) {
        if (instance != null) {
            this.withAuthorities(instance.getAuthorities());
            this.withMode(instance.getMode());
            this.withResources(instance.getResources());
        }
    }

    @Override
    public A addToAuthorities(int index, Authority item) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        AuthorityBuilder builder = new AuthorityBuilder(item);
        if (index < 0 || index >= this.authorities.size()) {
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        } else {
            this._visitables.get((Object)"authorities").add(index, builder);
            this.authorities.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToAuthorities(int index, Authority item) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        AuthorityBuilder builder = new AuthorityBuilder(item);
        if (index < 0 || index >= this.authorities.size()) {
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        } else {
            this._visitables.get((Object)"authorities").set(index, builder);
            this.authorities.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAuthorities(Authority ... items) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAuthorities(Collection<Authority> items) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuthorities(Authority ... items) {
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").remove(builder);
            if (this.authorities == null) continue;
            this.authorities.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAuthorities(Collection<Authority> items) {
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").remove(builder);
            if (this.authorities == null) continue;
            this.authorities.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAuthorities(Predicate<AuthorityBuilder> predicate) {
        if (this.authorities == null) {
            return (A)this;
        }
        Iterator<AuthorityBuilder> each = this.authorities.iterator();
        List visitables = this._visitables.get((Object)"authorities");
        while (each.hasNext()) {
            AuthorityBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Authority> getAuthorities() {
        return this.authorities != null ? VerificationPolicySpecFluentImpl.build(this.authorities) : null;
    }

    @Override
    public List<Authority> buildAuthorities() {
        return this.authorities != null ? VerificationPolicySpecFluentImpl.build(this.authorities) : null;
    }

    @Override
    public Authority buildAuthority(int index) {
        return this.authorities.get(index).build();
    }

    @Override
    public Authority buildFirstAuthority() {
        return this.authorities.get(0).build();
    }

    @Override
    public Authority buildLastAuthority() {
        return this.authorities.get(this.authorities.size() - 1).build();
    }

    @Override
    public Authority buildMatchingAuthority(Predicate<AuthorityBuilder> predicate) {
        for (AuthorityBuilder item : this.authorities) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAuthority(Predicate<AuthorityBuilder> predicate) {
        for (AuthorityBuilder item : this.authorities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAuthorities(List<Authority> authorities) {
        if (this.authorities != null) {
            this._visitables.get((Object)"authorities").clear();
        }
        if (authorities != null) {
            this.authorities = new ArrayList();
            for (Authority item : authorities) {
                this.addToAuthorities(item);
            }
        } else {
            this.authorities = null;
        }
        return (A)this;
    }

    @Override
    public A withAuthorities(Authority ... authorities) {
        if (this.authorities != null) {
            this.authorities.clear();
            this._visitables.remove((Object)"authorities");
        }
        if (authorities != null) {
            for (Authority item : authorities) {
                this.addToAuthorities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorities() {
        return this.authorities != null && !this.authorities.isEmpty();
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> addNewAuthority() {
        return new AuthoritiesNestedImpl();
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> addNewAuthorityLike(Authority item) {
        return new AuthoritiesNestedImpl(-1, item);
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> setNewAuthorityLike(int index, Authority item) {
        return new AuthoritiesNestedImpl(index, item);
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> editAuthority(int index) {
        if (this.authorities.size() <= index) {
            throw new RuntimeException("Can't edit authorities. Index exceeds size.");
        }
        return this.setNewAuthorityLike(index, this.buildAuthority(index));
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> editFirstAuthority() {
        if (this.authorities.size() == 0) {
            throw new RuntimeException("Can't edit first authorities. The list is empty.");
        }
        return this.setNewAuthorityLike(0, this.buildAuthority(0));
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> editLastAuthority() {
        int index = this.authorities.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last authorities. The list is empty.");
        }
        return this.setNewAuthorityLike(index, this.buildAuthority(index));
    }

    @Override
    public VerificationPolicySpecFluent.AuthoritiesNested<A> editMatchingAuthority(Predicate<AuthorityBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.authorities.size(); ++i) {
            if (!predicate.test(this.authorities.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching authorities. No match found.");
        }
        return this.setNewAuthorityLike(index, this.buildAuthority(index));
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    public A addToResources(int index, ResourcePattern item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(index, builder);
            this.resources.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToResources(int index, ResourcePattern item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").set(index, builder);
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(ResourcePattern ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<ResourcePattern> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(ResourcePattern ... items) {
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<ResourcePattern> items) {
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResources(Predicate<ResourcePatternBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<ResourcePatternBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            ResourcePatternBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourcePattern> getResources() {
        return this.resources != null ? VerificationPolicySpecFluentImpl.build(this.resources) : null;
    }

    @Override
    public List<ResourcePattern> buildResources() {
        return this.resources != null ? VerificationPolicySpecFluentImpl.build(this.resources) : null;
    }

    @Override
    public ResourcePattern buildResource(int index) {
        return this.resources.get(index).build();
    }

    @Override
    public ResourcePattern buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public ResourcePattern buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public ResourcePattern buildMatchingResource(Predicate<ResourcePatternBuilder> predicate) {
        for (ResourcePatternBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<ResourcePatternBuilder> predicate) {
        for (ResourcePatternBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<ResourcePattern> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (ResourcePattern item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(ResourcePattern ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (ResourcePattern item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public A addNewResource(String pattern) {
        return this.addToResources(new ResourcePattern(pattern));
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> addNewResourceLike(ResourcePattern item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> setNewResourceLike(int index, ResourcePattern item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public VerificationPolicySpecFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourcePatternBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerificationPolicySpecFluentImpl that = (VerificationPolicySpecFluentImpl)o;
        if (!Objects.equals(this.authorities, that.authorities)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        return Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.authorities, this.mode, this.resources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorities != null) {
            sb.append("authorities:");
            sb.append(this.authorities + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourcesNestedImpl<N>
    extends ResourcePatternFluentImpl<VerificationPolicySpecFluent.ResourcesNested<N>>
    implements VerificationPolicySpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourcePatternBuilder builder;
        int index;

        ResourcesNestedImpl(int index, ResourcePattern item) {
            this.index = index;
            this.builder = new ResourcePatternBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new ResourcePatternBuilder(this);
        }

        @Override
        public N and() {
            return (N)VerificationPolicySpecFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }

    class AuthoritiesNestedImpl<N>
    extends AuthorityFluentImpl<VerificationPolicySpecFluent.AuthoritiesNested<N>>
    implements VerificationPolicySpecFluent.AuthoritiesNested<N>,
    Nested<N> {
        AuthorityBuilder builder;
        int index;

        AuthoritiesNestedImpl(int index, Authority item) {
            this.index = index;
            this.builder = new AuthorityBuilder(this, item);
        }

        AuthoritiesNestedImpl() {
            this.index = -1;
            this.builder = new AuthorityBuilder(this);
        }

        @Override
        public N and() {
            return (N)VerificationPolicySpecFluentImpl.this.setToAuthorities(this.index, this.builder.build());
        }

        @Override
        public N endAuthority() {
            return this.and();
        }
    }
}

