/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.tekton.pipeline.v1alpha1.KeyRef;
import java.util.Objects;

public class KeyRefFluent<A extends KeyRefFluent<A>>
extends BaseFluent<A> {
    private String data;
    private String hashAlgorithm;
    private String kms;
    private SecretReference secretRef;

    public KeyRefFluent() {
    }

    public KeyRefFluent(KeyRef instance) {
        KeyRef keyRef = instance = instance != null ? instance : new KeyRef();
        if (instance != null) {
            this.withData(instance.getData());
            this.withHashAlgorithm(instance.getHashAlgorithm());
            this.withKms(instance.getKms());
            this.withSecretRef(instance.getSecretRef());
            this.withData(instance.getData());
            this.withHashAlgorithm(instance.getHashAlgorithm());
            this.withKms(instance.getKms());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    public String getData() {
        return this.data;
    }

    public A withData(String data) {
        this.data = data;
        return (A)((Object)this);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public A withHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return (A)((Object)this);
    }

    public boolean hasHashAlgorithm() {
        return this.hashAlgorithm != null;
    }

    public String getKms() {
        return this.kms;
    }

    public A withKms(String kms) {
        this.kms = kms;
        return (A)((Object)this);
    }

    public boolean hasKms() {
        return this.kms != null;
    }

    public SecretReference getSecretRef() {
        return this.secretRef;
    }

    public A withSecretRef(SecretReference secretRef) {
        this.secretRef = secretRef;
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyRefFluent that = (KeyRefFluent)((Object)o);
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        if (!Objects.equals(this.hashAlgorithm, that.hashAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.kms, that.kms)) {
            return false;
        }
        return Objects.equals(this.secretRef, that.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.hashAlgorithm, this.kms, this.secretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data + ",");
        }
        if (this.hashAlgorithm != null) {
            sb.append("hashAlgorithm:");
            sb.append(this.hashAlgorithm + ",");
        }
        if (this.kms != null) {
            sb.append("kms:");
            sb.append(this.kms + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }
}

