package io.fabric8.tekton.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TektonSchemaBuilder extends TektonSchemaFluentImpl<TektonSchemaBuilder> implements VisitableBuilder<TektonSchema,TektonSchemaBuilder>{

    TektonSchemaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TektonSchemaBuilder(){
            this(true);
    }
    public TektonSchemaBuilder(Boolean validationEnabled){
            this(new TektonSchema(), validationEnabled);
    }
    public TektonSchemaBuilder(TektonSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public TektonSchemaBuilder(TektonSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TektonSchema(), validationEnabled);
    }
    public TektonSchemaBuilder(TektonSchemaFluent<?> fluent,TektonSchema instance){
            this(fluent, instance, true);
    }
    public TektonSchemaBuilder(TektonSchemaFluent<?> fluent,TektonSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClusterTask(instance.getClusterTask()); 
            fluent.withClusterTaskList(instance.getClusterTaskList()); 
            fluent.withPipeline(instance.getPipeline()); 
            fluent.withPipelineList(instance.getPipelineList()); 
            fluent.withPipelineResource(instance.getPipelineResource()); 
            fluent.withPipelineResourceList(instance.getPipelineResourceList()); 
            fluent.withPipelineRun(instance.getPipelineRun()); 
            fluent.withPipelineRunList(instance.getPipelineRunList()); 
            fluent.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            fluent.withTask(instance.getTask()); 
            fluent.withTaskList(instance.getTaskList()); 
            fluent.withTaskRun(instance.getTaskRun()); 
            fluent.withTaskRunList(instance.getTaskRunList()); 
            this.validationEnabled = validationEnabled; 
    }
    public TektonSchemaBuilder(TektonSchema instance){
            this(instance,true);
    }
    public TektonSchemaBuilder(TektonSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClusterTask(instance.getClusterTask()); 
            this.withClusterTaskList(instance.getClusterTaskList()); 
            this.withPipeline(instance.getPipeline()); 
            this.withPipelineList(instance.getPipelineList()); 
            this.withPipelineResource(instance.getPipelineResource()); 
            this.withPipelineResourceList(instance.getPipelineResourceList()); 
            this.withPipelineRun(instance.getPipelineRun()); 
            this.withPipelineRunList(instance.getPipelineRunList()); 
            this.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            this.withTask(instance.getTask()); 
            this.withTaskList(instance.getTaskList()); 
            this.withTaskRun(instance.getTaskRun()); 
            this.withTaskRunList(instance.getTaskRunList()); 
            this.validationEnabled = validationEnabled; 
    }
    public TektonSchemaBuilder(Validator validator){
            this(new TektonSchema(), true);
    }
    public TektonSchemaBuilder(TektonSchemaFluent<?> fluent,TektonSchema instance,Validator validator){
            this.fluent = fluent; 
            fluent.withClusterTask(instance.getClusterTask()); 
            fluent.withClusterTaskList(instance.getClusterTaskList()); 
            fluent.withPipeline(instance.getPipeline()); 
            fluent.withPipelineList(instance.getPipelineList()); 
            fluent.withPipelineResource(instance.getPipelineResource()); 
            fluent.withPipelineResourceList(instance.getPipelineResourceList()); 
            fluent.withPipelineRun(instance.getPipelineRun()); 
            fluent.withPipelineRunList(instance.getPipelineRunList()); 
            fluent.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            fluent.withTask(instance.getTask()); 
            fluent.withTaskList(instance.getTaskList()); 
            fluent.withTaskRun(instance.getTaskRun()); 
            fluent.withTaskRunList(instance.getTaskRunList()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TektonSchemaBuilder(TektonSchema instance,Validator validator){
            this.fluent = this; 
            this.withClusterTask(instance.getClusterTask()); 
            this.withClusterTaskList(instance.getClusterTaskList()); 
            this.withPipeline(instance.getPipeline()); 
            this.withPipelineList(instance.getPipelineList()); 
            this.withPipelineResource(instance.getPipelineResource()); 
            this.withPipelineResourceList(instance.getPipelineResourceList()); 
            this.withPipelineRun(instance.getPipelineRun()); 
            this.withPipelineRunList(instance.getPipelineRunList()); 
            this.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            this.withTask(instance.getTask()); 
            this.withTaskList(instance.getTaskList()); 
            this.withTaskRun(instance.getTaskRun()); 
            this.withTaskRunList(instance.getTaskRunList()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TektonSchema build(){
            TektonSchema buildable = new TektonSchema(fluent.getClusterTask(),fluent.getClusterTaskList(),fluent.getPipeline(),fluent.getPipelineList(),fluent.getPipelineResource(),fluent.getPipelineResourceList(),fluent.getPipelineRun(),fluent.getPipelineRunList(),fluent.getPipelineRunTaskRunStatus(),fluent.getTask(),fluent.getTaskList(),fluent.getTaskRun(),fluent.getTaskRunList());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TektonSchemaBuilder that = (TektonSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
