package io.fabric8.tekton.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ValidationSchemaBuilder extends ValidationSchemaFluentImpl<ValidationSchemaBuilder> implements VisitableBuilder<ValidationSchema,ValidationSchemaBuilder>{

    ValidationSchemaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ValidationSchemaBuilder(){
            this(true);
    }
    public ValidationSchemaBuilder(Boolean validationEnabled){
            this(new ValidationSchema(), validationEnabled);
    }
    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ValidationSchema(), validationEnabled);
    }
    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent,ValidationSchema instance){
            this(fluent, instance, true);
    }
    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent,ValidationSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClusterTask(instance.getClusterTask()); 
            fluent.withClusterTaskList(instance.getClusterTaskList()); 
            fluent.withPipeline(instance.getPipeline()); 
            fluent.withPipelineList(instance.getPipelineList()); 
            fluent.withPipelineResource(instance.getPipelineResource()); 
            fluent.withPipelineResourceList(instance.getPipelineResourceList()); 
            fluent.withPipelineRun(instance.getPipelineRun()); 
            fluent.withPipelineRunList(instance.getPipelineRunList()); 
            fluent.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            fluent.withTask(instance.getTask()); 
            fluent.withTaskList(instance.getTaskList()); 
            fluent.withTaskRun(instance.getTaskRun()); 
            fluent.withTaskRunList(instance.getTaskRunList()); 
            this.validationEnabled = validationEnabled; 
    }
    public ValidationSchemaBuilder(ValidationSchema instance){
            this(instance,true);
    }
    public ValidationSchemaBuilder(ValidationSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClusterTask(instance.getClusterTask()); 
            this.withClusterTaskList(instance.getClusterTaskList()); 
            this.withPipeline(instance.getPipeline()); 
            this.withPipelineList(instance.getPipelineList()); 
            this.withPipelineResource(instance.getPipelineResource()); 
            this.withPipelineResourceList(instance.getPipelineResourceList()); 
            this.withPipelineRun(instance.getPipelineRun()); 
            this.withPipelineRunList(instance.getPipelineRunList()); 
            this.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            this.withTask(instance.getTask()); 
            this.withTaskList(instance.getTaskList()); 
            this.withTaskRun(instance.getTaskRun()); 
            this.withTaskRunList(instance.getTaskRunList()); 
            this.validationEnabled = validationEnabled; 
    }
    public ValidationSchemaBuilder(Validator validator){
            this(new ValidationSchema(), true);
    }
    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent,ValidationSchema instance,Validator validator){
            this.fluent = fluent; 
            fluent.withClusterTask(instance.getClusterTask()); 
            fluent.withClusterTaskList(instance.getClusterTaskList()); 
            fluent.withPipeline(instance.getPipeline()); 
            fluent.withPipelineList(instance.getPipelineList()); 
            fluent.withPipelineResource(instance.getPipelineResource()); 
            fluent.withPipelineResourceList(instance.getPipelineResourceList()); 
            fluent.withPipelineRun(instance.getPipelineRun()); 
            fluent.withPipelineRunList(instance.getPipelineRunList()); 
            fluent.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            fluent.withTask(instance.getTask()); 
            fluent.withTaskList(instance.getTaskList()); 
            fluent.withTaskRun(instance.getTaskRun()); 
            fluent.withTaskRunList(instance.getTaskRunList()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ValidationSchemaBuilder(ValidationSchema instance,Validator validator){
            this.fluent = this; 
            this.withClusterTask(instance.getClusterTask()); 
            this.withClusterTaskList(instance.getClusterTaskList()); 
            this.withPipeline(instance.getPipeline()); 
            this.withPipelineList(instance.getPipelineList()); 
            this.withPipelineResource(instance.getPipelineResource()); 
            this.withPipelineResourceList(instance.getPipelineResourceList()); 
            this.withPipelineRun(instance.getPipelineRun()); 
            this.withPipelineRunList(instance.getPipelineRunList()); 
            this.withPipelineRunTaskRunStatus(instance.getPipelineRunTaskRunStatus()); 
            this.withTask(instance.getTask()); 
            this.withTaskList(instance.getTaskList()); 
            this.withTaskRun(instance.getTaskRun()); 
            this.withTaskRunList(instance.getTaskRunList()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ValidationSchema build(){
            ValidationSchema buildable = new ValidationSchema(fluent.getClusterTask(),fluent.getClusterTaskList(),fluent.getPipeline(),fluent.getPipelineList(),fluent.getPipelineResource(),fluent.getPipelineResourceList(),fluent.getPipelineRun(),fluent.getPipelineRunList(),fluent.getPipelineRunTaskRunStatus(),fluent.getTask(),fluent.getTaskList(),fluent.getTaskRun(),fluent.getTaskRunList());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ValidationSchemaBuilder that = (ValidationSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
