package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterTaskBuilder extends ClusterTaskFluentImpl<ClusterTaskBuilder> implements VisitableBuilder<ClusterTask,ClusterTaskBuilder>{

    ClusterTaskFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterTaskBuilder(){
            this(true);
    }
    public ClusterTaskBuilder(Boolean validationEnabled){
            this(new ClusterTask(), validationEnabled);
    }
    public ClusterTaskBuilder(ClusterTaskFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterTaskBuilder(ClusterTaskFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterTask(), validationEnabled);
    }
    public ClusterTaskBuilder(ClusterTaskFluent<?> fluent,ClusterTask instance){
            this(fluent, instance, true);
    }
    public ClusterTaskBuilder(ClusterTaskFluent<?> fluent,ClusterTask instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterTaskBuilder(ClusterTask instance){
            this(instance,true);
    }
    public ClusterTaskBuilder(ClusterTask instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterTaskBuilder(Validator validator){
            this(new ClusterTask(), true);
    }
    public ClusterTaskBuilder(ClusterTaskFluent<?> fluent,ClusterTask instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterTaskBuilder(ClusterTask instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterTask build(){
            ClusterTask buildable = new ClusterTask(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterTaskBuilder that = (ClusterTaskBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
