package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class OutputsFluentImpl<A extends OutputsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OutputsFluent<A>{

    private List<TaskResourceBuilder> resources;
    private List<TestResultBuilder> results;

    public OutputsFluentImpl(){
    }
    public OutputsFluentImpl(Outputs instance){
            this.withResources(instance.getResources()); 
            this.withResults(instance.getResults()); 
    }

    public A addToResources(int index,TaskResource item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,TaskResource item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(TaskResource... items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<TaskResource> items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(TaskResource... items){
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<TaskResource> items){
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskResource> getResources(){
            return build(resources);
    }

    public List<TaskResource> buildResources(){
            return build(resources);
    }

    public TaskResource buildResource(int index){
            return this.resources.get(index).build();
    }

    public TaskResource buildFirstResource(){
            return this.resources.get(0).build();
    }

    public TaskResource buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public TaskResource buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate){
            for (TaskResourceBuilder item: resources) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate){
            for (TaskResourceBuilder item: resources) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResources(List<TaskResource> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<TaskResourceBuilder>(); for (TaskResource item : resources){this.addToResources(item);}} else { this.resources = new ArrayList<TaskResourceBuilder>();} return (A) this;
    }

    public A withResources(TaskResource... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (TaskResource item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public A addNewResource(String name,String outputImageDir,String targetPath,String type){
            return (A)addToResources(new TaskResource(name, outputImageDir, targetPath, type));
    }

    public OutputsFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public OutputsFluent.ResourcesNested<A> addNewResourceLike(TaskResource item){
            return new ResourcesNestedImpl(-1, item);
    }

    public OutputsFluent.ResourcesNested<A> setNewResourceLike(int index,TaskResource item){
            return new ResourcesNestedImpl(index, item);
    }

    public OutputsFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public OutputsFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public OutputsFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public OutputsFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public A addToResults(int index,TestResult item){
            if (this.results == null) {this.results = new ArrayList<TestResultBuilder>();}
            TestResultBuilder builder = new TestResultBuilder(item);_visitables.get("results").add(index >= 0 ? index : _visitables.get("results").size(), builder);this.results.add(index >= 0 ? index : results.size(), builder); return (A)this;
    }

    public A setToResults(int index,TestResult item){
            if (this.results == null) {this.results = new ArrayList<TestResultBuilder>();}
            TestResultBuilder builder = new TestResultBuilder(item);
            if (index < 0 || index >= _visitables.get("results").size()) { _visitables.get("results").add(builder); } else { _visitables.get("results").set(index, builder);}
            if (index < 0 || index >= results.size()) { results.add(builder); } else { results.set(index, builder);}
             return (A)this;
    }

    public A addToResults(TestResult... items){
            if (this.results == null) {this.results = new ArrayList<TestResultBuilder>();}
            for (TestResult item : items) {TestResultBuilder builder = new TestResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
    }

    public A addAllToResults(Collection<TestResult> items){
            if (this.results == null) {this.results = new ArrayList<TestResultBuilder>();}
            for (TestResult item : items) {TestResultBuilder builder = new TestResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
    }

    public A removeFromResults(TestResult... items){
            for (TestResult item : items) {TestResultBuilder builder = new TestResultBuilder(item);_visitables.get("results").remove(builder);if (this.results != null) {this.results.remove(builder);}} return (A)this;
    }

    public A removeAllFromResults(Collection<TestResult> items){
            for (TestResult item : items) {TestResultBuilder builder = new TestResultBuilder(item);_visitables.get("results").remove(builder);if (this.results != null) {this.results.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public List<TestResult> getResults(){
            return build(results);
    }

    public List<TestResult> buildResults(){
            return build(results);
    }

    public TestResult buildResult(int index){
            return this.results.get(index).build();
    }

    public TestResult buildFirstResult(){
            return this.results.get(0).build();
    }

    public TestResult buildLastResult(){
            return this.results.get(results.size() - 1).build();
    }

    public TestResult buildMatchingResult(io.fabric8.kubernetes.api.builder.Predicate<TestResultBuilder> predicate){
            for (TestResultBuilder item: results) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResult(io.fabric8.kubernetes.api.builder.Predicate<TestResultBuilder> predicate){
            for (TestResultBuilder item: results) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResults(List<TestResult> results){
            if (this.results != null) { _visitables.get("results").removeAll(this.results);}
            if (results != null) {this.results = new ArrayList<TestResultBuilder>(); for (TestResult item : results){this.addToResults(item);}} else { this.results = new ArrayList<TestResultBuilder>();} return (A) this;
    }

    public A withResults(TestResult... results){
            if (this.results != null) {this.results.clear();}
            if (results != null) {for (TestResult item :results){ this.addToResults(item);}} return (A) this;
    }

    public Boolean hasResults(){
            return results != null && !results.isEmpty();
    }

    public A addNewResult(String format,String name,String path){
            return (A)addToResults(new TestResult(format, name, path));
    }

    public OutputsFluent.ResultsNested<A> addNewResult(){
            return new ResultsNestedImpl();
    }

    public OutputsFluent.ResultsNested<A> addNewResultLike(TestResult item){
            return new ResultsNestedImpl(-1, item);
    }

    public OutputsFluent.ResultsNested<A> setNewResultLike(int index,TestResult item){
            return new ResultsNestedImpl(index, item);
    }

    public OutputsFluent.ResultsNested<A> editResult(int index){
            if (results.size() <= index) throw new RuntimeException("Can't edit results. Index exceeds size.");
            return setNewResultLike(index, buildResult(index));
    }

    public OutputsFluent.ResultsNested<A> editFirstResult(){
            if (results.size() == 0) throw new RuntimeException("Can't edit first results. The list is empty.");
            return setNewResultLike(0, buildResult(0));
    }

    public OutputsFluent.ResultsNested<A> editLastResult(){
            int index = results.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last results. The list is empty.");
            return setNewResultLike(index, buildResult(index));
    }

    public OutputsFluent.ResultsNested<A> editMatchingResult(io.fabric8.kubernetes.api.builder.Predicate<TestResultBuilder> predicate){
            int index = -1;
            for (int i=0;i<results.size();i++) { 
            if (predicate.apply(results.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching results. No match found.");
            return setNewResultLike(index, buildResult(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OutputsFluentImpl that = (OutputsFluentImpl) o;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            return true;
    }


    public class ResourcesNestedImpl<N> extends TaskResourceFluentImpl<OutputsFluent.ResourcesNested<N>> implements OutputsFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskResourceBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,TaskResource item){
                    this.index = index;
                    this.builder = new TaskResourceBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new TaskResourceBuilder(this);
            }
    
    public N and(){
            return (N) OutputsFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}
    public class ResultsNestedImpl<N> extends TestResultFluentImpl<OutputsFluent.ResultsNested<N>> implements OutputsFluent.ResultsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TestResultBuilder builder;
        private final int index;
    
            ResultsNestedImpl(int index,TestResult item){
                    this.index = index;
                    this.builder = new TestResultBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.index = -1;
                    this.builder = new TestResultBuilder(this);
            }
    
    public N and(){
            return (N) OutputsFluentImpl.this.setToResults(index, builder.build());
    }
    public N endResult(){
            return and();
    }

}


}
