package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ParamBuilder extends ParamFluentImpl<ParamBuilder> implements VisitableBuilder<Param,ParamBuilder>{

    ParamFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ParamBuilder(){
            this(true);
    }
    public ParamBuilder(Boolean validationEnabled){
            this(new Param(), validationEnabled);
    }
    public ParamBuilder(ParamFluent<?> fluent){
            this(fluent, true);
    }
    public ParamBuilder(ParamFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Param(), validationEnabled);
    }
    public ParamBuilder(ParamFluent<?> fluent,Param instance){
            this(fluent, instance, true);
    }
    public ParamBuilder(ParamFluent<?> fluent,Param instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParamBuilder(Param instance){
            this(instance,true);
    }
    public ParamBuilder(Param instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParamBuilder(Validator validator){
            this(new Param(), true);
    }
    public ParamBuilder(ParamFluent<?> fluent,Param instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withValue(instance.getValue()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ParamBuilder(Param instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Param build(){
            Param buildable = new Param(fluent.getName(),fluent.getValue());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParamBuilder that = (ParamBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
