package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineDeclaredResourceBuilder extends PipelineDeclaredResourceFluentImpl<PipelineDeclaredResourceBuilder> implements VisitableBuilder<PipelineDeclaredResource,PipelineDeclaredResourceBuilder>{

    PipelineDeclaredResourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineDeclaredResourceBuilder(){
            this(true);
    }
    public PipelineDeclaredResourceBuilder(Boolean validationEnabled){
            this(new PipelineDeclaredResource(), validationEnabled);
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResourceFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineDeclaredResource(), validationEnabled);
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResourceFluent<?> fluent,PipelineDeclaredResource instance){
            this(fluent, instance, true);
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResourceFluent<?> fluent,PipelineDeclaredResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResource instance){
            this(instance,true);
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineDeclaredResourceBuilder(Validator validator){
            this(new PipelineDeclaredResource(), true);
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResourceFluent<?> fluent,PipelineDeclaredResource instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withType(instance.getType()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineDeclaredResourceBuilder(PipelineDeclaredResource instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withType(instance.getType()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineDeclaredResource build(){
            PipelineDeclaredResource buildable = new PipelineDeclaredResource(fluent.getName(),fluent.getType());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineDeclaredResourceBuilder that = (PipelineDeclaredResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
