package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;

public class PipelineFluentImpl<A extends PipelineFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PipelineSpecBuilder spec;
    private PipelineStatusBuilder status;

    public PipelineFluentImpl(){
    }
    public PipelineFluentImpl(Pipeline instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public PipelineFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public PipelineFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public PipelineFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public PipelineFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public PipelineFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PipelineSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public PipelineSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(PipelineSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new PipelineSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public PipelineFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public PipelineFluent.SpecNested<A> withNewSpecLike(PipelineSpec item){
            return new SpecNestedImpl(item);
    }

    public PipelineFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public PipelineFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new PipelineSpecBuilder().build());
    }

    public PipelineFluent.SpecNested<A> editOrNewSpecLike(PipelineSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PipelineStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public PipelineStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(PipelineStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new PipelineStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public PipelineFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public PipelineFluent.StatusNested<A> withNewStatusLike(PipelineStatus item){
            return new StatusNestedImpl(item);
    }

    public PipelineFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public PipelineFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new PipelineStatusBuilder().build());
    }

    public PipelineFluent.StatusNested<A> editOrNewStatusLike(PipelineStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineFluentImpl that = (PipelineFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PipelineFluent.MetadataNested<N>> implements PipelineFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) PipelineFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends PipelineSpecFluentImpl<PipelineFluent.SpecNested<N>> implements PipelineFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineSpecBuilder builder;
    
            SpecNestedImpl(PipelineSpec item){
                    this.builder = new PipelineSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new PipelineSpecBuilder(this);
            }
    
    public N and(){
            return (N) PipelineFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends PipelineStatusFluentImpl<PipelineFluent.StatusNested<N>> implements PipelineFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineStatusBuilder builder;
    
            StatusNestedImpl(PipelineStatus item){
                    this.builder = new PipelineStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new PipelineStatusBuilder(this);
            }
    
    public N and(){
            return (N) PipelineFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
