package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineRefBuilder extends PipelineRefFluentImpl<PipelineRefBuilder> implements VisitableBuilder<PipelineRef,PipelineRefBuilder>{

    PipelineRefFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineRefBuilder(){
            this(true);
    }
    public PipelineRefBuilder(Boolean validationEnabled){
            this(new PipelineRef(), validationEnabled);
    }
    public PipelineRefBuilder(PipelineRefFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineRefBuilder(PipelineRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineRef(), validationEnabled);
    }
    public PipelineRefBuilder(PipelineRefFluent<?> fluent,PipelineRef instance){
            this(fluent, instance, true);
    }
    public PipelineRefBuilder(PipelineRefFluent<?> fluent,PipelineRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRefBuilder(PipelineRef instance){
            this(instance,true);
    }
    public PipelineRefBuilder(PipelineRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRefBuilder(Validator validator){
            this(new PipelineRef(), true);
    }
    public PipelineRefBuilder(PipelineRefFluent<?> fluent,PipelineRef instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineRefBuilder(PipelineRef instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineRef build(){
            PipelineRef buildable = new PipelineRef(fluent.getApiVersion(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRefBuilder that = (PipelineRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
