package io.fabric8.tekton.pipeline.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import javax.validation.constraints.NotNull;

public class PipelineRefFluentImpl<A extends PipelineRefFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineRefFluent<A>{

    private String apiVersion;
    private String name;

    public PipelineRefFluentImpl(){
    }
    public PipelineRefFluentImpl(PipelineRef instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRefFluentImpl that = (PipelineRefFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
