package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceBindingBuilder extends PipelineResourceBindingFluentImpl<PipelineResourceBindingBuilder> implements VisitableBuilder<PipelineResourceBinding,PipelineResourceBindingBuilder>{

    PipelineResourceBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceBindingBuilder(){
            this(true);
    }
    public PipelineResourceBindingBuilder(Boolean validationEnabled){
            this(new PipelineResourceBinding(), validationEnabled);
    }
    public PipelineResourceBindingBuilder(PipelineResourceBindingFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceBindingBuilder(PipelineResourceBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResourceBinding(), validationEnabled);
    }
    public PipelineResourceBindingBuilder(PipelineResourceBindingFluent<?> fluent,PipelineResourceBinding instance){
            this(fluent, instance, true);
    }
    public PipelineResourceBindingBuilder(PipelineResourceBindingFluent<?> fluent,PipelineResourceBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withResourceRef(instance.getResourceRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceBindingBuilder(PipelineResourceBinding instance){
            this(instance,true);
    }
    public PipelineResourceBindingBuilder(PipelineResourceBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withResourceRef(instance.getResourceRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceBindingBuilder(Validator validator){
            this(new PipelineResourceBinding(), true);
    }
    public PipelineResourceBindingBuilder(PipelineResourceBindingFluent<?> fluent,PipelineResourceBinding instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withResourceRef(instance.getResourceRef()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceBindingBuilder(PipelineResourceBinding instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withResourceRef(instance.getResourceRef()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResourceBinding build(){
            PipelineResourceBinding buildable = new PipelineResourceBinding(fluent.getName(),fluent.getResourceRef());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceBindingBuilder that = (PipelineResourceBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
