package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface PipelineResourceBindingFluent<A extends PipelineResourceBindingFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildResourceRef instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceRef getResourceRef();
    public PipelineResourceRef buildResourceRef();
    public A withResourceRef(PipelineResourceRef resourceRef);
    public Boolean hasResourceRef();
    public A withNewResourceRef(String apiVersion,String name);
    public PipelineResourceBindingFluent.ResourceRefNested<A> withNewResourceRef();
    public PipelineResourceBindingFluent.ResourceRefNested<A> withNewResourceRefLike(PipelineResourceRef item);
    public PipelineResourceBindingFluent.ResourceRefNested<A> editResourceRef();
    public PipelineResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRef();
    public PipelineResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRefLike(PipelineResourceRef item);

    public interface ResourceRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceRefFluent<PipelineResourceBindingFluent.ResourceRefNested<N>>{

        
    public N and();    public N endResourceRef();
}


}
