package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceBuilder extends PipelineResourceFluentImpl<PipelineResourceBuilder> implements VisitableBuilder<PipelineResource,PipelineResourceBuilder>{

    PipelineResourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceBuilder(){
            this(true);
    }
    public PipelineResourceBuilder(Boolean validationEnabled){
            this(new PipelineResource(), validationEnabled);
    }
    public PipelineResourceBuilder(PipelineResourceFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceBuilder(PipelineResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResource(), validationEnabled);
    }
    public PipelineResourceBuilder(PipelineResourceFluent<?> fluent,PipelineResource instance){
            this(fluent, instance, true);
    }
    public PipelineResourceBuilder(PipelineResourceFluent<?> fluent,PipelineResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceBuilder(PipelineResource instance){
            this(instance,true);
    }
    public PipelineResourceBuilder(PipelineResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceBuilder(Validator validator){
            this(new PipelineResource(), true);
    }
    public PipelineResourceBuilder(PipelineResourceFluent<?> fluent,PipelineResource instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceBuilder(PipelineResource instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResource build(){
            PipelineResource buildable = new PipelineResource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceBuilder that = (PipelineResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
