package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceListBuilder extends PipelineResourceListFluentImpl<PipelineResourceListBuilder> implements VisitableBuilder<PipelineResourceList,PipelineResourceListBuilder>{

    PipelineResourceListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceListBuilder(){
            this(true);
    }
    public PipelineResourceListBuilder(Boolean validationEnabled){
            this(new PipelineResourceList(), validationEnabled);
    }
    public PipelineResourceListBuilder(PipelineResourceListFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceListBuilder(PipelineResourceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResourceList(), validationEnabled);
    }
    public PipelineResourceListBuilder(PipelineResourceListFluent<?> fluent,PipelineResourceList instance){
            this(fluent, instance, true);
    }
    public PipelineResourceListBuilder(PipelineResourceListFluent<?> fluent,PipelineResourceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceListBuilder(PipelineResourceList instance){
            this(instance,true);
    }
    public PipelineResourceListBuilder(PipelineResourceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceListBuilder(Validator validator){
            this(new PipelineResourceList(), true);
    }
    public PipelineResourceListBuilder(PipelineResourceListFluent<?> fluent,PipelineResourceList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceListBuilder(PipelineResourceList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResourceList build(){
            PipelineResourceList buildable = new PipelineResourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceListBuilder that = (PipelineResourceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
